GBU_31_V_1B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_31},
    type    = 6,
    mass    = 934.0,
    hMin    = 400.0,
    hMax    = 15000.0,
    Cx      = 0.00264,
    VyHold  = -100.0,
    Ag      = -1.23,
	
	name			= "GBU_31",
	model			= "GBU-31",
	user_name		= _("GBU-31(V)1/B"),
	display_name_short = "GBU-31",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	

	LaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1020,	1420,	2960,	5210,	8250,	12170,	15400,	16330,	16350,	17030,	
		500,	1150,	1990,	3160,	5170,	8150,	12500,	15710,	17000,	17020,	17040,	
		600,	1280,	1730,	3370,	5250,	8260,	12810,	16020,	18530,	20630,	22680,	
		700,	1390,	1790,	3150,	5100,	8350,	13110,	16320,	18820,	20930,	22980,	
		800,	1500,	2450,	3200,	5575,	8000,	13400,	16600,	19125,	21225,	23275,	
		900,	1600,	2575,	3400,	5425,	8200,	13700,	16900,	19400,	21500,	23575,	
		1000,	1700,	2150,	3350,	5600,	8400,	14000,	17175,	19700,	21800,	23875,	
		2000,	2625,	3900,	5825,	8000,	12600,	16750,	19950,	22525,	24700,	26900,	
		3000,	2800,	5050,	7000,	10500,	15150,	19200,	22550,	25200,	27450,	29850,	
		4000,	3400,	5450,	8000,	12300,	17100,	21400,	24900,	27900,	30250,	32800,	
		5000,	5800,	5800,	9100,	12700,	18700,	23300,	27100,	30100,	32900,	35700,	
		6000,	5750,	6500,	10500,	15000,	20000,	24750,	29000,	32500,	35500,	38500,	
		7000,	6250,	7500,	11750,	15750,	21250,	26500,	31000,	34500,	37750,	41000,	
		8000,	8000,	9250,	10500,	16500,	22000,	27750,	32500,	36750,	40000,	44250,	
		9000,	8500,	9750,	11750,	17500,	22750,	28750,	33750,	38500,	42750,	46750,	
		10000,	10000,	11000,	13250,	15750,	23250,	29500,	35000,	40250,	45000,	49250,	
		11000,	10500,	12000,	14500,	16500,	23500,	29500,	35500,	41500,	47000,	52500,	
		12000,	11500,	13500,	15500,	18000,	20000,	30000,	36500,	43000,	49000,	54500,	
		13000,	14500,	14500,	19000,	19000,	21500,	30000,	37000,	44000,	50500,	56500,	
		14000,	17500,	20500,	20500,	20500,	26000,	26000,	37000,	44000,	52000,	58500,	
		15000,	19000,	19000,	19000,	27000,	27000,	27500,	37000,	44500,	53000,	60000,	
	},

	MinLaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	750,	1010,	1290,	1590,	1930,	2470,	2970,	3310,	3590,	3930,	
		500,	830,	1130,	1410,	1690,	2040,	2600,	3110,	3480,	3780,	4090,	
		600,	1070,	1190,	1500,	1790,	2140,	2730,	3250,	3720,	4170,	4620,	
		700,	1170,	1250,	1560,	1860,	2230,	2840,	3380,	3880,	4350,	4820,	
		800,	1275,	1350,	1625,	1975,	2275,	2950,	3525,	4025,	4500,	5000,	
		900,	1325,	1425,	1700,	2025,	2375,	3025,	3625,	4175,	4650,	5175,	
		1000,	1400,	1425,	1750,	2075,	2450,	3125,	3725,	4275,	4825,	5350,	
		2000,	1925,	1725,	2200,	2600,	3125,	3700,	4450,	5200,	5900,	6625,	
		3000,	1350,	1750,	2300,	2850,	3400,	3950,	4650,	5700,	6550,	7500,	
		4000,	2000,	4050,	2200,	2900,	3500,	4050,	4750,	7150,	6950,	8100,	
		5000,	2400,	2900,	2000,	2600,	3400,	4000,	4600,	5600,	8600,	8400,	
		6000,	2250,	4000,	3250,	2500,	4250,	3750,	4500,	5500,	9500,	9000,	
		7000,	2250,	3750,	3500,	3750,	4500,	3500,	4250,	6750,	7250,	9500,	
		8000,	2250,	3500,	3500,	4000,	4500,	5500,	4000,	7500,	7500,	10250,	
		9000,	2000,	3500,	3750,	4000,	4750,	5750,	6500,	8000,	7500,	10750,	
		10000,	2000,	3500,	4000,	4250,	5250,	6000,	6750,	8500,	8250,	11750,	
		11000,	2000,	3500,	4500,	4500,	5000,	6500,	7000,	9000,	9000,	12500,	
		12000,	2000,	3500,	4500,	4500,	5500,	6500,	7500,	10000,	10500,	13500,	
		13000,	2000,	3500,	5000,	5000,	6000,	7000,	8000,	11000,	11500,	14500,	
		14000,	2500,	4000,	5500,	5500,	6000,	7000,	8500,	6500,	13000,	15500,	
		15000,	2500,	4000,	5000,	6000,	6500,	7000,	9000,	8000,	14000,	17000,	
	},

	AspectDistData =
	{
		13,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	8,		10,		15,		17,		22,		27,		34,		40,		42,		45,		
		500,	9,		13,		11,		19,		21,		29,		33,		40,		45,		45,		
		600,	9,		13,		9,		18,		22,		29,		34,		39,		43,		45,		
		700,	9,		15,		14,		19,		21,		29,		35,		39,		44,		45,		
		800,	10,		5,		18,		17,		24,		30,		35,		40,		44,		45,		
		900,	11,		10,		20,		25,		25,		31,		35,		40,		44,		45,		
		1000,	11,		19,		20,		20,		29,		31,		35,		41,		44,		45,		
		2000,	5,		29,		27,		23,		32,		35,		39,		43,		45,		45,		
		3000,	30,		34,		37,		36,		34,		39,		42,		45,		45,		45,		
		4000,	36,		39,		44,		40,		39,		42,		45,		45,		45,		45,		
		5000,	34,		45,		45,		45,		43,		44,		45,		45,		45,		45,		
		6000,	44,		42,		45,		45,		44,		45,		45,		45,		45,		45,		
		7000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
	},

	MaxTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11,		10.7,	18.2,	25.2,	47.2,	44.6,	52.2,	50.3,	45.6,	44.2,		
		500,	12.4,	15.9,	22.2,	30.9,	38.8,	45.8,	53.3,	52.6,	48.9,	44.2,		
		600,	13.9,	12.9,	24.5,	25.6,	33.8,	47,		54.3,	59.5,	63.2,	66.4,		
		700,	15.1,	13.2,	19.1,	24.3,	38,		48,		55.3,	60.4,	64.2,	67.3,		
		800,	16.3,	20.3,	18.6,	32.8,	34.1,	55.7,	56.2,	61.5,	65.1,	68.2,		
		900,	17.4,	21.6,	21.4,	25.8,	39,		50.2,	57.3,	62.3,	65.9,	69.1,		
		1000,	18.5,	16.5,	19.7,	29.4,	37.2,	58.2,	58.1,	63.3,	66.9,	70,		
		2000,	27.6,	32.3,	41.5,	50.9,	65.1,	63.8,	69.8,	76.4,	76.1,	79.2,		
		3000,	31.1,	41.4,	41.5,	59.4,	67.5,	71.7,	77.8,	84.7,	91.3,	97.5,		
		4000,	36.1,	43.7,	54.8,	60.4,	72.6,	78,		85.2,	92.7,	100,	106,	
		5000,	52.2,	46.2,	63,		58.9,	76.2,	84.6,	91.8,	99.5,	109.1,	114.3,	
		6000,	52.8,	49.7,	71.1,	87.6,	84.3,	88.1,	98.1,	108,	115.1,	121.8,	
		7000,	57,		60.1,	80.8,	95.2,	90.4,	94.9,	103.9,	114,	122.7,	130.1,	
		8000,	66.5,	69,		65,		100.6,	107.2,	98.9,	108.3,	121.7,	127.9,	136.3,	
		9000,	69.4,	71.6,	78.7,	98,		107.8,	100.8,	111.8,	125.9,	134.9,	141.6,	
		10000,	78,		77.7,	85.5,	95.1,	94.4,	104,	117.3,	132.5,	142.9,	149.6,	
		11000,	79.3,	81.2,	91,		97,		106.6,	104.3,	115.6,	134,	146.5,	151.3,	
		12000,	84,		89.2,	94.7,	103,	106.4,	99.9,	118.8,	139.9,	146.2,	150.1,	
		13000,	105.2,	94.1,	115.2,	105.5,	112.7,	104.5,	118.5,	135.8,	150.9,	151.7,	
		14000,	103.3,	109.8,	121.9,	111.9,	137,	125.5,	109.8,	137,	144.9,	153.5,	
		15000,	109.4,	120.7,	108.8,	126,	139.1,	131.1,	115.6,	129.8,	148.7,	155.5,	
	},

	MinTOF =
	{
		21,		10,

				100,		150,		200,		250,		300,		350,		400,		450,		500,		550,		
		400,	8.4,		7.7,		7.2,		6.9,		6.8,		7.3,		7.8,		7.8,		7.7,		7.7,		
		500,	9.4,		8.7,		8,			7.5,		7.3,		7.8,		8.2,		8.3,		8.2,		8.1,		
		600,	12.1,		9.5,		8.8,		8.2,		7.9,		8.3,		8.7,		8.9,		9.1,		9.2,		
		700,	13.5,		10.3,		9.4,		8.8,		8.4,		8.8,		9.1,		9.4,		9.6,		9.7,		
		800,	14.8,		11,			10.1,		9.4,		8.8,		9.2,		9.6,		9.8,		10,			10.1,		
		900,	15.6,		11.7,		10.8,		10,			9.4,		9.6,		9.9,		10.3,		10.4,		10.6,		
		1000,	16.7,		12.4,		11.4,		10.5,		9.9,		10,			10.3,		10.6,		10.9,		11,		
		2000,	24.5,		18.3,		17,			15.6,		14.6,		13.8,		13.7,		13.9,		14.2,		14.4,		
		3000,	26.6,		24.1,		21.8,		20.1,		18.6,		17.4,		16.6,		16.7,		16.9,		17.1,		
		4000,	34.8,		39,			26.6,		24.1,		22.3,		20.8,		19.8,		20.9,		19.3,		19.6,		
		5000,	39,			41.7,		31.8,		30.2,		26.1,		24.2,		22.9,		21.9,		23.4,		21.6,		
		6000,	41.9,		47.2,		34.4,		35,			28.8,		28.6,		26.2,		25,			26.3,		24.2,		
		7000,	45,			48.6,		38.3,		34.3,		32,			34.8,		31.4,		27.8,		27,			26.7,		
		8000,	47.7,		50.6,		42.5,		37.9,		35.1,		33,			37.5,		30.6,		29.9,		29.2,		
		9000,	51.2,		52.9,		46.6,		40.9,		38,			35.8,		34.3,		33.3,		33.3,		31.7,		
		10000,	53.7,		53.3,		49.9,		44,			40.6,		38.5,		37.1,		36,			35.9,		34.3,		
		11000,	54.9,		56,			51.4,		46.7,		43.8,		41.1,		39.9,		38.6,		38.6,		36.7,		
		12000,	57.7,		58.5,		56.8,		49.8,		46.3,		44,			42.6,		41.2,		40.6,		39.2,		
		13000,	59.7,		60.9,		61.5,		52.8,		48.7,		46.6,		45.4,		43.8,		43,			41.6,		
		14000,	60,			61.9,		62.8,		54.8,		51.7,		49.6,		48.1,		54.9,		45.1,		44,		
		15000,	61.9,		63.7,		65.1,		57.4,		54.1,		52.7,		50.9,		55.2,		47.5,		46.4,		
	},

	MidTOF =
	{
		21,		10,

				100,		150,		200,		250,		300,		350,		400,		450,		500,		550,		
		400,	9.7,		8.6,		10.8,		14.6,		18.4,		23.7,		27.2,		26.4,		24.5,		23.8,		
		500,	11,			11.3,		11.8,		14.5,		18.3,		24.1,		27.5,		27.4,		25.6,		23.9,		
		600,	13.2,		10.6,		12.7,		14.8,		18.7,		25,			28,			30.2,		31.9,		33,		
		700,	14.2,		11.1,		12.4,		14.2,		18.7,		25.4,		29,			31.1,		32.4,		33.5,		
		800,	15.5,		14.1,		12.9,		15.9,		18.2,		26.5,		29.5,		31.6,		33,			34,		
		900,	16.5,		15.2,		14,			15.5,		18.5,		26.9,		29.9,		32,			33.5,		34.5,		
		1000,	17.4,		13.5,		13.8,		15.9,		19,			27.6,		30.3,		32.6,		34,			35.3,		
		2000,	25.5,		22.3,		23.7,		23.7,		29.9,		34.3,		36.8,		38.3,		39.4,		40.5,		
		3000,	30.4,		33.2,		28.7,		31.7,		36.5,		39.8,		40.9,		43.6,		44.4,		45.5,		
		4000,	35.3,		40.4,		33.3,		37.4,		41.3,		43.5,		45.8,		50.5,		49.1,		50,		
		5000,	43.9,		43.4,		35.8,		37.8,		44.6,		46.8,		49.4,		51.3,		54.8,		53.8,		
		6000,	42.9,		47.2,		51.5,		45.6,		50.1,		49.2,		52.6,		55,			59.6,		57.1,		
		7000,	45.6,		50,			58.8,		56.6,		55.2,		52.5,		55.6,		58.3,		58.2,		59.6,		
		8000,	52.5,		55.3,		57.1,		53.5,		58,			60.1,		56.8,		63.9,		60.3,		64.1,		
		9000,	54,			56.7,		60.1,		68.4,		58.7,		61.8,		60.9,		64,			62.9,		67.3,		
		10000,	57.6,		59.8,		63,			55.4,		60.8,		63.2,		62.4,		66.7,		65.9,		70.4,		
		11000,	59.3,		61.4,		65,			59.5,		58.9,		63,			65.1,		69.8,		68.4,		73.7,		
		12000,	61.3,		64,			66,			66.9,		53.2,		62.1,		64.4,		71.7,		72.3,		75.4,		
		13000,	66.8,		65.5,		71.7,		69,			56.8,		62.3,		65.6,		72.5,		74.6,		77.4,		
		14000,	74.7,		78.1,		74.5,		71.1,		69.9,		57,			67.2,		64.6,		76.7,		80.3,		
		15000,	77.2,		73.2,		70.8,		81.5,		75.6,		59,			67.1,		67.4,		78.4,		82.7,		
	},

	fuze = specialize_fuze_parameters(
		predefined_fuze("DSU33"),
		{ tdd_position = { 1.86, 0, 0 } }
	),
	
	warhead	= predefined_warhead("Mk_84"),
	
	fm =
    {
		mass			= 925.0,
		caliber			= 0.457,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.457,
		I				= 515.2,
		I_x				= 24.8,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.066, 0.036},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		Sw				= 0.164*3,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 1.5,
		Mw_x			= 4.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 890.0,
		Ka					= 12.0,
		Tc					= 0.1,
		Kx					= 0.4,
		Krx					= 4.0,
		gload_limit			= 3.0,
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(0),
		KD0					= 0.164 / 925,
		KDI					= 0.6 * 925 / 0.5,
		KLM					= 1.3 * 0.164 * 3 / 925,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_31",
			file		= "GBU-31",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-31(V)1/B"),
			index		= GBU_31,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.55,
	}
}

declare_weapon(GBU_31_V_1B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU-31}",
	attribute		= GBU_31_V_1B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_31_V_1B.Cx,
	Picture			= "GBU31.png",
	displayName		= _("GBU-31(V)1/B - JDAM, 2000lb GPS Guided Bomb"),
	Weight			= GBU_31_V_1B.mass,
	Elements  		= {{ShapeName = "GBU-31"}},
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL")
})

GBU_31_V_2B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, WSTYPE_PLACEHOLDER},
	type			= 6,
	mass			= 934.0,
	hMin			= 400.0,
	hMax			= 15000.0,
	Cx				= 0.00264,
	VyHold			= -100.0,
	Ag				= -1.23,
	
	name			= "GBU_31_V_2B",
	model			= "GBU-31",
	user_name		= _("GBU-31(V)2/B"),
	display_name_short = "GBU-31",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	

	encyclopediaAnimation = {
		args = {
			[57] = 1
		}
	},
	
	LaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	990,	1750,	2940,	5190,	7750,	12390,	14800,	17300,	17320,	17350,	
		500,	1150,	1600,	3070,	5210,	8370,	12700,	15950,	17300,	17320,	17340,	
		600,	1000,	1520,	3230,	5230,	7980,	13010,	16240,	17290,	17310,	17350,	
		700,	1370,	1650,	3330,	5390,	8010,	13310,	16540,	17310,	17330,	17360,	
		800,	1450,	1750,	3475,	5325,	8325,	13575,	16800,	19350,	21475,	23550,	
		900,	1575,	1850,	3550,	5475,	8725,	13875,	17075,	19650,	21775,	23850,	
		1000,	1650,	1950,	3700,	5750,	8650,	14175,	17375,	19925,	22050,	24150,	
		2000,	2550,	3575,	4600,	6750,	12675,	16850,	20100,	22675,	24900,	27125,	
		3000,	3400,	4100,	7000,	7500,	15150,	19250,	22650,	25300,	27600,	30000,	
		4000,	3950,	5700,	7200,	12200,	17050,	21450,	25050,	27850,	30300,	32900,	
		5000,	4800,	6900,	9800,	12700,	18700,	23300,	27200,	30300,	32900,	35800,	
		6000,	5250,	7750,	9000,	14750,	20000,	24750,	29000,	32250,	35500,	38500,	
		7000,	7750,	9000,	11250,	15750,	21000,	26500,	28500,	28750,	28750,	38500,	
		8000,	8750,	10250,	12000,	16500,	22000,	27750,	32250,	36500,	38500,	38500,	
		9000,	10000,	11750,	13250,	14000,	20500,	28250,	33750,	38500,	38500,	38750,	
		10000,	11500,	13250,	14500,	17000,	23000,	29000,	35000,	38500,	38500,	38750,	
		11000,	12500,	14500,	16000,	17500,	23500,	29500,	35500,	38500,	38500,	38500,	
		12000,	14000,	16000,	17000,	19000,	23500,	30000,	36000,	42500,	49000,	54500,	
		13000,	15000,	17000,	19000,	20500,	23500,	30000,	36500,	43000,	50000,	56500,	
		14000,	16500,	19000,	20500,	22500,	24000,	30000,	36500,	44000,	51500,	58500,	
		15000,	18500,	20500,	22500,	24000,	25500,	29500,	36500,	44500,	52000,	60000,	
	},

	MinLaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	720,	970,	1210,	1480,	1790,	2410,	2930,	3420,	3740,	4060,	
		500,	780,	1030,	1300,	1580,	1910,	2450,	2990,	3400,	3700,	4010,	
		600,	960,	1080,	1370,	1650,	1960,	2520,	3060,	3460,	3770,	4080,	
		700,	1000,	1140,	1450,	1730,	2040,	2600,	3150,	3530,	3860,	4190,	
		800,	1075,	1200,	1500,	1775,	2125,	2675,	3225,	3750,	4225,	4700,	
		900,	1250,	1225,	1550,	1850,	2200,	2750,	3300,	3825,	4350,	4825,	
		1000,	1300,	1250,	1600,	1900,	2225,	2825,	3350,	3925,	4425,	4975,	
		2000,	1800,	1425,	3625,	2150,	2725,	3200,	3775,	4450,	5200,	5925,	
		3000,	1200,	1300,	1800,	2100,	2800,	3300,	3850,	4550,	5400,	6400,	
		4000,	2100,	2100,	1400,	2700,	2650,	3700,	4200,	4400,	5250,	6450,	
		5000,	2100,	4400,	2600,	2800,	3400,	3900,	4400,	5100,	5000,	6200,	
		6000,	2000,	4250,	2500,	3250,	3500,	4000,	4500,	5250,	6250,	6000,	
		7000,	2000,	3500,	6500,	3250,	3750,	4500,	4750,	5250,	6000,	7500,	
		8000,	1750,	3250,	3000,	3250,	4000,	4500,	5000,	6000,	7000,	8000,	
		9000,	1750,	3250,	3000,	3000,	3750,	4500,	5250,	6250,	7250,	8500,	
		10000,	1500,	3000,	3250,	3250,	4000,	4500,	5500,	6250,	7500,	9000,	
		11000,	1500,	3000,	3000,	3000,	4000,	5000,	5500,	6500,	8000,	9500,	
		12000,	1000,	2500,	3000,	3500,	4000,	4500,	5500,	7000,	9000,	11000,	
		13000,	1000,	2500,	3500,	3500,	3500,	4500,	5500,	7000,	9500,	12500,	
		14000,	1500,	2500,	3000,	3000,	3500,	4500,	6000,	8000,	10500,	13500,	
		15000,	1500,	2000,	3000,	3000,	3500,	4500,	6000,	8500,	11500,	14500,	
	},

	AspectDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	7,		4,		14,		16,		23,		24,		33,		38,		43,		14,		
		500,	8,		6,		13,		18,		21,		22,		27,		38,		44,		32,		
		600,	11,		13,		12,		18,		22,		29,		33,		39,		44,		42,		
		700,	8,		15,		13,		18,		23,		21,		33,		40,		44,		42,		
		800,	8,		16,		10,		24,		23,		21,		34,		39,		42,		44,		
		900,	4,		17,		14,		25,		21,		21,		34,		39,		42,		45,		
		1000,	5,		19,		12,		25,		23,		31,		35,		39,		42,		45,		
		2000,	8,		25,		28,		32,		30,		35,		39,		42,		45,		45,		
		3000,	16,		14,		35,		42,		35,		39,		42,		45,		45,		45,		
		4000,	28,		6,		45,		40,		40,		42,		45,		45,		45,		45,		
		5000,	36,		17,		9,		45,		42,		44,		45,		45,		45,		45,		
		6000,	45,		25,		9,		45,		44,		45,		45,		45,		45,		45,		
		7000,	44,		33,		10,		45,		45,		45,		45,		45,		45,		45,		
		8000,	45,		41,		23,		45,		45,		45,		45,		45,		45,		45,		
		9000,	45,		45,		31,		45,		45,		45,		45,		45,		45,		45,		
		10000,	45,		45,		41,		45,		45,		45,		45,		45,		45,		45,		
		11000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		12000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		21,		
		13000,	45,		45,		45,		45,		45,		28,		45,		45,		45,		14,		
		14000,	45,		45,		45,		45,		45,		45,		29,		45,		45,		10,		
		15000,	45,		44,		45,		45,		45,		45,		21,		45,		21,		10,		
	},

	MaxTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.4,	15.7,	18,		31.7,	32.6,	45.9,	49.2,	54.4,	49.4,	45.2,	
		500,	13.3,	13.5,	18.2,	29.5,	48.8,	47,		54.6,	53.9,	49,		45.1,	
		600,	11.5,	11.3,	21.3,	26.1,	31,		48.1,	55.6,	53.4,	49,		44.7,	
		700,	16.1,	12.3,	21.7,	29.8,	32.8,	49.2,	56.6,	53.1,	48.5,	44.6,	
		800,	17.3,	13.2,	22.8,	26.1,	38.2,	50,		57.5,	62.6,	66.3,	69.4,	
		900,	18.7,	14,		22.1,	28.3,	47.1,	55.4,	58.4,	63.6,	67.2,	70.3,	
		1000,	19.8,	15,		31.5,	29.4,	43.4,	55.8,	59.4,	64.5,	68.1,	71.2,	
		2000,	30.4,	33.8,	30.8,	35.7,	62,		64.1,	70,		76.7,	77,		80.1,	
		3000,	39.9,	40.3,	41.9,	38.8,	67.7,	71.7,	77.4,	84.8,	91.8,	98.1,	
		4000,	46,		55.7,	50.9,	58.1,	74.1,	78,		85.5,	92.4,	100.4,	105.8,	
		5000,	47.3,	61,		73.2,	59.3,	77.9,	84,		92,		100.4,	108.8,	115.4,	
		6000,	57.1,	64.7,	76.1,	91.7,	82.7,	89.1,	97.6,	106.7,	117.1,	121.6,	
		7000,	66,		70.1,	56.7,	99.2,	88.5,	96.1,	95.1,	96.7,	90,		125,	
		8000,	69.2,	75.3,	75,		107.4,	98.9,	98.8,	107.7,	120.3,	123.8,	124.5,	
		9000,	75.7,	84.8,	85.5,	56.6,	81.6,	100.6,	112,	126.1,	128.5,	160.2,	
		10000,	85.1,	87.2,	89.7,	77,		130.3,	105.2,	116.1,	123.8,	126,	116.7,	
		11000,	85.4,	90.5,	95.1,	86.5,	91.1,	103,	115.9,	123.4,	128.4,	96.1,	
		12000,	94.4,	95.8,	98.5,	100.9,	90.7,	104.3,	117.6,	138.3,	146.5,	151.1,	
		13000,	94.5,	104.3,	103.2,	106,	91.3,	103.6,	117.1,	134.1,	145.4,	151.7,	
		14000,	103.2,	105.2,	106.8,	113.6,	84.8,	103.9,	117.3,	138.4,	146.5,	153.5,	
		15000,	107,	109.5,	113.9,	115.9,	115.7,	100.6,	114,	127.6,	140.7,	155.7,	
	},

	MinTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	8.4,	7.7,	7,		6.6,	6.4,	7.2,	7.7,	8.1,	8.1,	8,		
		500,	9.4,	8.6,	7.8,	7.3,	7,		7.4,	7.9,	8.1,	8,		7.9,	
		600,	11.2,	9.5,	8.6,	7.9,	7.5,	7.8,	8.2,	8.3,	8.3,	8.1,	
		700,	11.9,	10.3,	9.3,	8.6,	8.1,	8.2,	8.6,	8.6,	8.5,	8.4,	
		800,	13.2,	11.1,	10,		9.2,	8.6,	8.6,	8.9,	9.2,	9.4,	9.5,	
		900,	16.3,	11.8,	10.7,	9.9,	9.1,	9,		9.2,	9.5,	9.8,	9.8,	
		1000,	17.3,	12.6,	11.4,	10.5,	9.6,	9.5,	9.5,	9.8,	10,		10.2,	
		2000,	26.4,	19.3,	21.1,	16,		14.7,	13.3,	12.8,	12.7,	12.9,	13.1,	
		3000,	29.9,	26.4,	23.3,	21.2,	18.9,	17.5,	16.2,	15.6,	15.2,	15.4,	
		4000,	38.4,	30.6,	31.6,	24.5,	23.4,	21,		19.7,	18.8,	17.8,	17.5,	
		5000,	41.4,	49.1,	30.9,	28.6,	26.1,	24.3,	22.9,	21.8,	21.1,	20,		
		6000,	44.8,	53.5,	36.5,	31.4,	29.5,	27.6,	26.1,	24.8,	23.7,	23.1,	
		7000,	47.8,	53.3,	39,		35.8,	32.6,	30.5,	29.1,	27.9,	26.8,	25.5,	
		8000,	52.4,	55.2,	44,		40.1,	35.7,	33.6,	32,		30.5,	29.3,	28.2,	
		9000,	54.8,	56.9,	48.8,	46,		40.7,	36.9,	34.9,	33.4,	32.1,	30.9,	
		10000,	59.3,	60.6,	52.5,	48.9,	42.3,	40.1,	37.8,	36.6,	35.1,	33.6,	
		11000,	57.3,	58.6,	51.2,	55.1,	45.4,	42.4,	40.9,	39.6,	37.9,	36.4,	
		12000,	61.3,	61.7,	54.9,	52.6,	51,		46.5,	44.3,	42.3,	40.2,	38.6,	
		13000,	63.9,	64.7,	63,		56.2,	55.9,	49.7,	49.5,	45.9,	43,		41,		
		14000,	62.8,	67.3,	62.2,	60.5,	62.4,	53.3,	50.3,	48,		45.4,	43.3,	
		15000,	66.2,	74.1,	72.1,	63.9,	66.5,	60.5,	54,		50.9,	47.7,	45.7,	
	},

	MidTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	9.5,	9.7,	10.8,	14,		17.1,	23.6,	25.7,	28.2,	26.1,	24.3,	
		500,	11,		9.6,	11.3,	14.3,	18.2,	24.1,	27.6,	27.8,	26,		24.2,	
		600,	11.3,	9.9,	11.9,	14.4,	17.8,	25.2,	28,		27.8,	26,		24.2,	
		700,	14.9,	10.8,	12.4,	14.8,	17.6,	25.5,	29,		27.8,	26,		24.3,	
		800,	15.7,	11.5,	13,		14.9,	18.5,	26,		29.4,	31.6,	33,		34,		
		900,	17.2,	12.2,	13.5,	15.2,	19.4,	26.4,	29.9,	32.1,	33.4,	34.5,	
		1000,	18.3,	13,		14.3,	16.1,	19.1,	27.4,	30.4,	32.6,	34,		35,		
		2000,	27.6,	20.5,	25.1,	19.9,	28.8,	32.8,	35.2,	37.2,	38.5,	40,		
		3000,	33.4,	27.5,	27.1,	22.6,	34.9,	37.5,	40.1,	41.4,	42.5,	43.9,	
		4000,	38.4,	44,		27.8,	36.2,	38.5,	43.1,	44.4,	45.1,	45.7,	47.1,	
		5000,	42.7,	53.6,	41.4,	38.5,	44.9,	46.8,	49,		50.7,	48.3,	50.2,	
		6000,	46.1,	54.7,	43.2,	48.4,	48,		49.8,	50.9,	51.6,	53.5,	52.5,	
		7000,	49.9,	56.4,	48.5,	53.3,	51.3,	55.3,	49.2,	45.9,	42.7,	52.9,	
		8000,	52.6,	58.9,	54.9,	63.7,	55.9,	55,		55.7,	59.7,	56.7,	52.6,	
		9000,	62.7,	68.9,	66.8,	46,		49.6,	56,		60.7,	61.5,	56.1,	52.7,	
		10000,	65.6,	71.4,	72.8,	56.8,	55.1,	58.6,	62.6,	59.6,	55.4,	52.2,	
		11000,	68.1,	73.6,	75.1,	57.6,	56.5,	58,		60.2,	60.1,	55.5,	51.9,	
		12000,	70.1,	75.1,	76,		77.9,	56.7,	57.7,	61.5,	65.3,	69.5,	72.1,	
		13000,	73.3,	76.5,	81.2,	79.8,	56.1,	58.5,	60.8,	65.1,	70.8,	74.1,	
		14000,	78.1,	80.5,	79.2,	80.8,	57.9,	59,		61.7,	66.9,	72.2,	76.4,	
		15000,	82.7,	80.7,	82.1,	80.7,	60.9,	58.5,	61.9,	68,		72.2,	77.5,	
	},

	fuze = specialize_fuze_parameters(
		predefined_fuze("DSU33"),
		{ tdd_position = { 1.86, 0, 0 } }
	),
	
	warhead	= predefined_warhead("Mk_84"),
	
	fm =
    {
		mass			= 934.0,
		caliber			= 0.457,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.457,
		I				= 515.2,
		I_x				= 24.8,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.066, 0.036},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		Sw				= 0.164*3,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 1.5,
		Mw_x			= 4.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 890.0,
		Ka					= 12.0,
		Tc					= 0.1,
		Kx					= 0.4,
		Krx					= 4.0,
		gload_limit			= 3.0,
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.164 / 934,
		KDI					= 0.6 * 934 / 0.5,
		KLM					= 1.3 * 0.164 * 3 / 934,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_31_V_2B",
			file		= "GBU-31",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-31(V)2/B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.5,
	}
}

declare_weapon(GBU_31_V_2B)

declare_loadout({
	category		= CAT_BOMBS,
	CLSID			= "{GBU_31_V_2B}",
	attribute		= GBU_31_V_2B.wsTypeOfWeapon,
	Count			= 1,
	Cx_pil			= GBU_31_V_2B.Cx,
	Picture			= "GBU31.png",
	displayName		= _("GBU-31(V)2/B - JDAM, 2000lb GPS Guided Bomb"),
	Weight			= GBU_31_V_2B.mass,
	Elements		= {{ShapeName = "GBU-31"}},
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL_USN")
})

GBU_31_V_3B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_31_V_3B},
    type    = 6,
    mass    = 981.0,
    hMin    = 400.0,
    hMax    = 15000.0,
    Cx      = 0.00170,
    VyHold  = -100.0,
    Ag      = -1.23,
    
	name			= "GBU_31_V_3B",
	model			= "GBU31_V_3B_BLU109",
	user_name		= _("GBU-31(V)3/B"),
	display_name_short = "GBU-31",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	
		
	LaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1030,	1670,	3050,	5060,	8020,	14180,	18710,	22060,	22680,	23630,	
		500,	800,	1400,	3100,	5220,	8110,	14510,	19030,	22800,	26250,	30670,	
		600,	1260,	1520,	3230,	5280,	9780,	14830,	19350,	23120,	26570,	29750,	
		700,	1380,	1650,	3350,	5450,	8380,	15150,	19660,	23440,	26880,	29760,	
		800,	1450,	1675,	3450,	5550,	8500,	15450,	19950,	23750,	27175,	29750,	
		900,	1575,	2200,	3600,	5675,	8400,	15750,	20300,	24050,	27550,	29775,	
		1000,	1650,	2600,	3750,	5825,	8675,	16075,	20575,	24375,	27850,	29775,	
		2000,	2550,	3550,	4525,	7150,	10700,	18875,	23500,	27375,	29800,	29825,	
		3000,	2700,	2750,	6750,	11150,	16200,	21350,	26150,	29750,	29800,	29850,	
		4000,	4450,	6000,	7250,	12400,	18050,	23500,	27450,	27450,	27500,	31300,	
		5000,	5400,	6900,	9900,	12800,	19700,	25500,	28600,	28600,	28600,	33900,	
		6000,	5250,	8000,	9000,	13000,	20750,	27000,	29000,	29000,	29250,	35000,	
		7000,	7750,	9250,	11250,	12750,	21750,	28000,	34250,	38750,	38750,	38750,	
		8000,	8750,	10250,	12000,	13250,	22500,	29000,	33750,	33750,	33750,	38750,	
		9000,	10250,	11750,	13500,	17000,	23250,	30000,	36750,	40000,	40250,	40250,	
		10000,	11750,	13500,	14750,	17250,	23500,	30500,	37500,	41750,	41750,	42000,	
		11000,	13000,	14500,	16000,	18000,	23500,	30500,	38000,	45500,	46500,	46500,	
		12000,	14500,	16000,	17500,	19000,	24000,	30500,	38500,	46500,	46500,	46500,	
		13000,	15500,	17500,	19000,	21000,	24000,	30500,	38500,	47000,	56000,	64500,	
		14000,	17000,	19500,	21000,	23000,	24500,	30500,	38000,	47000,	56500,	65500,	
		15000,	19000,	21000,	23000,	24000,	26000,	30000,	38000,	46500,	56500,	66000,	
	},

	MinLaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	730,	990,	1250,	1530,	1830,	2530,	3230,	3800,	4180,	17910,	
		500,	760,	1040,	1340,	1620,	1930,	2570,	3210,	3800,	4340,	18220,	
		600,	830,	1100,	1410,	1700,	2120,	2650,	3280,	3870,	4410,	4940,	
		700,	1010,	1160,	1470,	1950,	2090,	2740,	3370,	3970,	4530,	5050,	
		800,	1100,	1200,	1525,	1850,	2150,	2825,	3450,	4050,	4650,	5175,	
		900,	1250,	1300,	1575,	1900,	2225,	2875,	3525,	4175,	4775,	5300,	
		1000,	1300,	2550,	1625,	1925,	2275,	2950,	3600,	4250,	4875,	5400,	
		2000,	1825,	1425,	2700,	2200,	2625,	3400,	4050,	4825,	5650,	6225,	
		3000,	1100,	1650,	1750,	2350,	2900,	3450,	4100,	4900,	5750,	6650,	
		4000,	2350,	4200,	2200,	2750,	2750,	3350,	3900,	4400,	5250,	6700,	
		5000,	2200,	4600,	2700,	2900,	3600,	4100,	4500,	5000,	5700,	6400,	
		6000,	2000,	4500,	2750,	3000,	3750,	4250,	4750,	5250,	6000,	6000,	
		7000,	2000,	3750,	6500,	3000,	3750,	4500,	5250,	6000,	6750,	8000,	
		8000,	2000,	3250,	3000,	3000,	4000,	4500,	5250,	5750,	6750,	8250,	
		9000,	2000,	3250,	3250,	3500,	4000,	4750,	5500,	6500,	7750,	8750,	
		10000,	1750,	3250,	3500,	3500,	4250,	4750,	5500,	6750,	8250,	9500,	
		11000,	1500,	3000,	3000,	3500,	4000,	4500,	5500,	7000,	9000,	10500,	
		12000,	1000,	2500,	3000,	3500,	4000,	4500,	5500,	7500,	9500,	11000,	
		13000,	1000,	2500,	3500,	3500,	4000,	4500,	6000,	8000,	10500,	13500,	
		14000,	1500,	2500,	3000,	3500,	3500,	4500,	6000,	8000,	11500,	14500,	
		15000,	1500,	2000,	3000,	3000,	4000,	5000,	6000,	8500,	12500,	15500,	
	},

	AspectDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	7,		4,		14,		19,		24,		26,		33,		20,		44,		8,		
		500,	2,		12,		12,		17,		23,		29,		34,		39,		43,		22,		
		600,	10,		13,		12,		18,		21,		28,		34,		39,		9,		18,		
		700,	7,		14,		12,		17,		24,		29,		35,		40,		44,		40,		
		800,	8,		15,		12,		18,		22,		30,		23,		40,		44,		43,		
		900,	5,		4,		11,		24,		29,		30,		35,		41,		45,		33,		
		1000,	5,		3,		13,		26,		29,		31,		36,		41,		45,		45,		
		2000,	8,		25,		31,		34,		23,		35,		39,		44,		45,		45,		
		3000,	24,		43,		26,		35,		36,		39,		43,		45,		45,		45,		
		4000,	22,		8,		45,		40,		40,		42,		45,		45,		45,		45,		
		5000,	31,		17,		8,		45,		41,		43,		45,		45,		45,		45,		
		6000,	44,		24,		8,		45,		44,		45,		45,		45,		45,		45,		
		7000,	44,		32,		13,		45,		45,		45,		45,		45,		45,		43,		
		8000,	45,		41,		23,		45,		45,		45,		45,		45,		45,		45,		
		9000,	45,		45,		28,		45,		45,		45,		45,		45,		45,		39,		
		10000,	45,		45,		37,		45,		45,		45,		45,		45,		45,		39,		
		11000,	45,		45,		42,		45,		34,		45,		45,		45,		45,		36,		
		12000,	45,		45,		44,		45,		45,		45,		45,		45,		45,		37,		
	},

	MaxTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.7,	13.3,	23.2,	27.2,	32.5,	51.4,	62.6,	68.4,	63.1,	60.8,		
		500,	9.5,	10.3,	18.3,	27.4,	36.7,	58.9,	63.7,	71.5,	78.4,	90.2,		
		600,	14.7,	11.3,	20.3,	27.9,	39.4,	54.2,	64.7,	72.5,	79.3,	84.3,		
		700,	16.2,	12.2,	19.7,	27.4,	36.1,	61.8,	65.7,	73.5,	80.2,	83.7,		
		800,	17.2,	12.5,	21.6,	28.8,	39.9,	61.1,	66.7,	74.4,	81,		82.9,		
		900,	18.6,	21.4,	22.8,	29,		36.1,	62,		67.8,	75.3,	82.3,	82.4,		
		1000,	19.7,	24.6,	24.1,	35.4,	39.3,	62.6,	68.6,	76.3,	83.1,	117.7,	
		2000,	30.3,	33.3,	28.4,	41.5,	66.6,	70.8,	80.4,	85.7,	119.1,	77.2,		
		3000,	33.5,	28.3,	38.8,	59.3,	71.1,	78.2,	88.1,	98.4,	125.5,	82.5,		
		4000,	49.4,	55.2,	55.8,	59.7,	73.8,	84.6,	92.1,	94.3,	83.9,	82.9,		
		5000,	57.8,	59.5,	73.2,	61.4,	80.3,	91.3,	94.5,	95.5,	79.1,	100.5,	
		6000,	57.7,	65.4,	75.6,	63.4,	88,		95,		95.2,	92.5,	77.2,	88.6,		
		7000,	65.1,	72.1,	54.1,	50.7,	92.6,	97.8,	110.8,	125.7,	123.6,	103.7,	
		8000,	68.3,	74,		77.2,	52.9,	105.8,	101.4,	110.1,	121.2,	91.9,	94.7,		
		9000,	79.4,	79.5,	86.8,	75.3,	100.5,	103.6,	118.1,	124.8,	166.7,	98.8,		
		10000,	82.6,	88.2,	90.6,	76.8,	88.6,	104.1,	121.5,	126.3,	172.6,	101.9,	
		11000,	86.8,	89,		93.4,	86.9,	87.5,	102.7,	120.4,	142.8,	140.6,	183.5,	
		12000,	92.7,	94.1,	97.5,	99,		92.2,	101.6,	117.3,	143.8,	145.3,	113.3,	
		13000,	94.5,	98.8,	101.3,	108.2,	93.5,	101.8,	119.1,	134.6,	149.7,	165.1,	
		14000,	99.9,	106.9,	108.4,	115.4,	103.4,	102.9,	115.5,	134.8,	152.8,	166.8,	
		15000,	108.3,	110.8,	115.1,	113.5,	117.2,	100.2,	116.1,	130.9,	151.3,	167.3,	
	},

	MinTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	8.5,	7.7,	7.4,	6.7,	6.5,	7.4,	8.3,	8.8,	8.8,	42.1,		
		500,	9.5,	8.7,	8.1,	7.4,	7.1,	7.7,	8.3,	8.8,	9.2,	42.6,		
		600,	10.4,	9.5,	8.7,	8.2,	7.8,	8,		8.6,	9.1,	9.4,	9.5,		
		700,	12,		10.4,	9.4,	8.9,	8.1,	8.4,	8.9,	9.4,	9.7,	9.8,		
		800,	13.4,	11.2,	10.1,	9.4,	8.7,	8.8,	9.2,	9.6,	10,		10.1,		
		900,	16.2,	11.9,	10.8,	10.2,	9.2,	9.2,	9.6,	10,		10.3,	10.4,		
		1000,	17.2,	24.4,	11.5,	10.6,	9.7,	9.6,	9.9,	10.3,	10.6,	10.7,		
		2000,	26.3,	19.4,	17.7,	16.1,	14.7,	13.4,	12.9,	12.9,	13.2,	13.1,		
		3000,	29.3,	25.3,	23.9,	20.7,	18.8,	17.1,	16,		15.4,	15.2,	15.2,		
		4000,	39.2,	44.3,	27.1,	24.4,	23.2,	21.2,	19.6,	18.5,	17.5,	17.2,		
		5000,	41.4,	49.6,	30.8,	28,		25.8,	24,		22.6,	21.5,	20.3,	19.4,		
		6000,	45,		53.6,	35.4,	32.4,	29.2,	27.3,	25.7,	24.4,	23.2,	22.9,		
		7000,	48.1,	54.4,	38.6,	37,		32.5,	30.3,	28.4,	27,		25.9,	24.9,		
		8000,	50.8,	55.8,	44.5,	41.8,	35.6,	33.4,	31.5,	30.2,	28.8,	27.4,		
		9000,	50.7,	57.6,	48.6,	43.4,	38.9,	36.2,	34.3,	32.7,	31.2,	30,		
		10000,	53.9,	55.6,	47.4,	45.4,	41.5,	39.3,	37.4,	35.5,	33.8,	32.6,		
		11000,	57.2,	58.3,	50.8,	49.1,	47,		42.9,	40.5,	38.4,	36.3,	35,		
		12000,	61.2,	61.5,	61.4,	54.8,	48.2,	48.2,	43.7,	41.1,	38.9,	37.6,		
		13000,	63.8,	64.6,	58.7,	58.4,	54,		51.7,	46.4,	43.8,	41.3,	39.8,		
		14000,	63.9,	69.4,	61.9,	61.8,	59.6,	56.1,	49.9,	47.3,	43.7,	42.2,		
		15000,	65.7,	70.7,	65.5,	68,		60.3,	57.9,	56.5,	50.3,	46,		44.6,		
	},

	MidTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	9.8,	10.4,	11.1,	13.7,	17.4,	26.4,	31.4,	34.1,	32.4,	50.8,		
		500,	9.5,	9.1,	11.3,	14.1,	17.9,	26.8,	31.9,	35.1,	38,		62.9,		
		600,	12.3,	10,		12,		14.4,	21.5,	27.8,	32.8,	35.6,	38.4,	40,		
		700,	14.8,	10.8,	12.5,	15.3,	18.3,	28.2,	32.8,	36.1,	38.9,	40,		
		800,	15.7,	11.4,	12.9,	15.2,	18.7,	29.2,	33.8,	36.6,	39.1,	40,		
		900,	17.2,	13.3,	13.7,	15.8,	18.5,	29.7,	33.8,	37.1,	40,		40,		
		1000,	18.2,	24.8,	14.5,	15.9,	19.1,	30.6,	35.4,	37.6,	40.5,	40,		
		2000,	27.4,	20.5,	21,		20.4,	23.6,	37.2,	40.4,	43.1,	43.2,	39.9,		
		3000,	33.2,	25.3,	26,		31.5,	37.8,	42.6,	46.2,	46.1,	42.2,	39.6,		
		4000,	38.9,	49,		29.1,	36.8,	40.9,	46.4,	46.9,	40.6,	37.8,	40.5,		
		5000,	42.9,	53.6,	47,		38.4,	48.5,	52.6,	47.4,	42.4,	39.4,	42.7,		
		6000,	46,		55.2,	48.3,	40.8,	51.3,	53,		48.6,	43,		40.4,	42.9,		
		7000,	49.9,	56.9,	47.7,	41,		53.5,	53.8,	58.4,	59.1,	52.8,	48.9,		
		8000,	59,		60.1,	59.4,	42.8,	54.8,	55,		56.1,	49.7,	46,		48.4,		
		9000,	63.8,	68.1,	70.3,	69.3,	55.2,	56.4,	61.5,	58.6,	54.2,	49.8,		
		10000,	67.2,	72.9,	73.2,	58.3,	56,		58.2,	60.3,	60.7,	56,		51.9,		
		11000,	69.6,	73.3,	74.6,	62,		54.9,	56.6,	62.1,	67,		61.4,	56.9,		
		12000,	71.7,	74.9,	77.2,	76.8,	55.6,	56.7,	61.6,	67.2,	61.6,	57,		
		13000,	73.5,	78.2,	80,		79.7,	56.5,	57.1,	61.9,	68.5,	73.4,	79.8,		
		14000,	78.4,	82.3,	80.3,	81.7,	56.8,	56.9,	59.9,	65.7,	74.1,	80.4,		
		15000,	83.6,	82.1,	83.2,	79.6,	61.5,	58.1,	60.3,	65.9,	74.3,	81.5,		
	},
	
	warhead	= predefined_warhead("BLU_109"),
	
	fm =
    {
		mass			= 961.0,
		caliber			= 0.368,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.368,
		I				= 592.5,
		I_x				= 32.5,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.066, 0.036},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		finsTau			= 0.1,
		Sw				= 0.1*5,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 1.5,
		Mw_x			= 6.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 890.0,
		Ka					= 12.0,
		Tc					= 0.1,
		Kx					= 0.4,
		Krx					= 4.0,
		gload_limit			= 3.0,
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.1 / 961,
		KDI					= 0.6 * 961 / 0.5,
		KLM					= 1.3 * 0.1 * 5 / 961,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_31_V_3B",
			file		= "GBU31_V_3B_BLU109",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-31(V)3/B"),
			index		= GBU_31_V_3B,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.55,
	}
}

declare_weapon(GBU_31_V_3B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU-31V3B}",
	attribute		= GBU_31_V_3B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_31_V_3B.Cx,
	Picture			= "GBU-31V3B.png",
	displayName		= _("GBU-31(V)3/B - JDAM, 2000lb GPS Guided Penetrator Bomb"),
	Weight			= GBU_31_V_3B.mass,
	Elements  		= {{ShapeName = "GBU31_V_3B_BLU109"}},
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TAILONLY")
})

GBU_31_V_4B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, WSTYPE_PLACEHOLDER},
	type			= 6,
	mass			= 970.0,
	hMin			= 400.0,
	hMax			= 15000.0,
	Cx				= 0.00264,
	VyHold			= -100.0,
	Ag				= -1.23,
	
	name			= "GBU_31_V_4B",
	model			= "GBU31_V_3B_BLU109",
	user_name		= _("GBU-31(V)4/B"),
	display_name_short = "GBU-31",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	

	encyclopediaAnimation = {
		args = {
			[57] = 1
		}
	},
	
	LaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1030,	1670,	3050,	5060,	8240,	14110,	16270,	22020,	24100,	24130,	
		500,	1150,	1400,	3080,	5210,	9080,	14430,	18980,	22770,	26240,	30620,	
		600,	1260,	1520,	3210,	5260,	8250,	14760,	19290,	21160,	26550,	29800,	
		700,	1370,	1650,	3330,	5390,	8430,	15080,	19620,	23410,	26860,	29800,	
		800,	1450,	1775,	3450,	5575,	8450,	15375,	19925,	23700,	27175,	29800,	
		900,	1575,	2075,	3600,	5675,	8550,	15675,	20225,	24000,	27525,	29825,	
		1000,	1650,	2575,	3750,	5825,	8675,	16000,	20525,	24325,	27875,	29825,	
		2000,	2550,	3550,	5550,	6725,	13375,	18825,	23450,	27350,	29825,	29875,	
		3000,	2700,	2750,	6750,	11250,	16150,	21300,	25950,	26000,	26050,	29900,	
		4000,	4450,	6000,	7250,	12550,	18000,	23450,	27050,	27050,	27100,	31450,	
		5000,	5500,	6900,	9900,	12900,	19600,	25400,	30700,	32800,	32800,	32900,	
		6000,	5250,	8000,	9000,	12500,	20500,	26750,	32500,	36500,	36750,	36500,	
		7000,	7750,	9250,	9250,	12750,	21750,	28000,	34250,	36500,	36750,	36750,	
		8000,	8750,	10250,	12000,	13500,	22500,	29000,	32500,	32750,	32750,	38750,	
		9000,	10250,	11750,	13250,	17000,	23000,	29750,	33750,	33750,	34000,	40750,	
		10000,	11500,	13250,	14750,	17250,	23500,	30250,	35250,	35250,	35250,	42000,	
		11000,	13000,	14500,	16000,	18000,	23500,	30500,	38000,	43000,	43000,	43500,	
		12000,	14500,	16000,	17500,	19000,	23500,	30500,	38000,	46000,	54500,	63000,	
		13000,	15500,	17500,	19000,	21000,	23500,	30500,	38000,	46500,	55500,	64500,	
		14000,	17000,	19000,	21000,	22500,	24500,	30000,	38000,	46500,	56000,	65500,	
		15000,	18500,	21000,	23000,	24000,	26000,	30000,	37500,	46500,	56500,	66000,	
	},

	MinLaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	730,	990,	1250,	1530,	1850,	2530,	3070,	3800,	4280,	4670,	
		500,	790,	1040,	1340,	1630,	2000,	2570,	3210,	3790,	4340,	16850,	
		600,	830,	1100,	1410,	1700,	2020,	2650,	3280,	3750,	4410,	4940,	
		700,	1020,	1160,	1470,	1780,	2100,	2730,	3360,	3970,	4530,	5050,	
		800,	1100,	1200,	1525,	1850,	2175,	2800,	3450,	4075,	4650,	5175,	
		900,	1250,	1300,	1575,	1900,	2225,	2875,	3525,	4175,	4775,	5300,	
		1000,	1300,	1325,	1625,	1950,	2275,	2975,	3600,	4250,	4875,	5400,	
		2000,	1825,	1450,	3100,	2175,	2825,	3375,	4025,	4825,	5625,	6225,	
		3000,	1100,	1650,	2050,	2400,	2950,	3450,	4150,	4650,	5450,	6650,	
		4000,	2350,	4200,	2200,	2750,	2800,	3900,	4400,	4450,	5250,	6700,	
		5000,	2300,	4600,	2700,	2900,	3600,	4100,	4700,	5400,	5200,	6400,	
		6000,	2000,	4500,	2750,	3000,	3750,	4500,	5000,	5750,	6500,	6250,	
		7000,	2000,	3750,	2750,	3000,	3750,	4500,	5250,	6000,	6750,	7750,	
		8000,	2000,	3250,	3000,	3250,	4000,	4500,	5250,	5750,	7000,	8500,	
		9000,	2000,	3250,	3250,	3500,	4000,	4750,	5250,	6000,	7250,	9000,	
		10000,	1750,	3250,	3500,	3500,	4250,	4750,	5500,	6250,	7750,	9500,	
		11000,	1500,	3000,	3000,	3500,	4000,	4500,	5500,	7000,	8500,	10500,	
		12000,	1000,	2500,	3000,	3500,	4000,	4500,	6000,	7500,	10000,	12500,	
		13000,	1000,	2500,	3500,	3500,	4000,	4500,	6000,	8000,	11000,	13500,	
		14000,	1500,	2500,	3500,	3500,	4000,	5000,	6000,	8500,	11500,	14500,	
		15000,	1500,	2000,	3000,	3500,	4000,	5000,	6000,	9000,	13000,	15500,	
	},

	AspectDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	7,		4,		14,		18,		23,		28,		36,		28,		21,		9,		
		500,	8,		11,		13,		17,		21,		28,		23,		15,		33,		37,		
		600,	10,		13,		12,		18,		23,		29,		34,		41,		37,		23,		
		700,	7,		14,		11,		18,		23,		30,		35,		34,		44,		45,		
		800,	8,		16,		12,		18,		23,		30,		35,		40,		44,		44,		
		900,	4,		7,		10,		17,		29,		30,		35,		41,		44,		43,		
		1000,	5,		7,		13,		26,		23,		30,		35,		40,		45,		42,		
		2000,	8,		25,		25,		30,		30,		35,		39,		43,		45,		45,		
		3000,	23,		42,		35,		35,		35,		38,		42,		45,		45,		45,		
		4000,	22,		8,		45,		39,		39,		41,		45,		45,		45,		45,		
		5000,	30,		17,		8,		45,		41,		43,		45,		45,		45,		45,		
		6000,	44,		24,		8,		45,		44,		45,		45,		45,		45,		45,		
		7000,	44,		32,		17,		45,		45,		45,		45,		45,		45,		45,		
		8000,	45,		41,		23,		45,		45,		45,		45,		45,		45,		45,		
		9000,	45,		45,		29,		45,		45,		45,		45,		45,		45,		38,		
		10000,	45,		45,		34,		45,		45,		45,		45,		45,		45,		39,		
		11000,	45,		45,		42,		45,		45,		45,		45,		45,		45,		39,		
		12000,	45,		45,		44,		45,		45,		45,		45,		45,		45,		45,		
		13000,	45,		45,		45,		45,		45,		28,		45,		45,		45,		13,		
		14000,	45,		45,		45,		45,		45,		45,		31,		45,		45,		6,		
		15000,	45,		45,		45,		45,		45,		45,		21,		45,		14,		7,		
	},
	
	MaxTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.7,	13.4,	23,		23.9,	32.4,	51.5,	51,		68,		69,		62,		
		500,	13.2,	10.3,	18.1,	27.4,	50.1,	59.1,	63.4,	71.1,	78.2,	89.6,	
		600,	14.7,	11.3,	19.2,	26.7,	36.4,	59.1,	64.1,	75.8,	79.1,	84.4,	
		700,	16,		12.3,	20.4,	28.4,	38.2,	60.3,	65.5,	73.3,	79.9,	83.7,	
		800,	17.2,	13.4,	21.7,	28.7,	39.2,	60.6,	66.5,	74.1,	80.9,	83,		
		900,	18.6,	16.9,	22.8,	29.1,	36.5,	61.8,	67.4,	75,		82,		82.5,	
		1000,	19.7,	24.7,	24.2,	36.1,	39.4,	62.4,	68.4,	76,		82.9,	117.6,	
		2000,	30.2,	33.2,	42.7,	34.8,	63.2,	70.3,	80.5,	91.1,	105,	77.2,	
		3000,	33.4,	28.3,	38.9,	59.7,	70,		78.1,	87.9,	88.7,	80,		83.8,	
		4000,	49.3,	54.7,	55.9,	60,		75.1,	83.9,	90.1,	91.5,	81.8,	84.7,	
		5000,	58.6,	59.4,	73,		63.1,	79.8,	90.8,	101.9,	106.2,	140.7,	83.2,	
		6000,	49.4,	65.4,	75.4,	58.4,	85.6,	94.9,	106.3,	117.7,	149,	96.8,	
		7000,	66,		72.2,	72.6,	50.6,	93.1,	97.9,	110.9,	116.2,	98.2,	90.6,	
		8000,	68.5,	74,		76,		52.4,	106.3,	101.4,	106.1,	90.7,	84,		94.5,	
		9000,	79.3,	79.5,	84,		75.7,	123.9,	103.8,	108.1,	112.9,	88.2,	100.7,	
		10000,	88.4,	85.7,	90.6,	77.2,	89,		103.6,	110.7,	112.2,	91.4,	97.6,	
		11000,	87,		89.1,	93.3,	87.7,	87.8,	102.7,	122.5,	129.6,	126.4,	102.2,	
		12000,	93,		94.2,	97.5,	99,		87.8,	102,	121.1,	135.4,	152.9,	161.1,	
		13000,	94.8,	98.9,	101.2,	108.1,	88.8,	102.2,	117.9,	133.9,	147.4,	165.3,	
		14000,	100.1,	103.3,	108.5,	111.1,	104.4,	99.1,	115.9,	131.7,	146.4,	167.1,	
		15000,	105.2,	111,	115.2,	113.4,	117.1,	100.6,	112.8,	131.3,	151.7,	167.7,	
	},

	MinTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	8.5,	7.8,	7.2,	6.7,	6.6,	7.4,	7.9,	8.8,	9,		9,		
		500,	9.5,	8.7,	8.1,	7.4,	7.2,	7.7,	8.3,	8.8,	9.2,	38.6,	
		600,	10.4,	9.5,	8.7,	8.1,	7.6,	8,		8.6,	8.8,	9.4,	9.5,	
		700,	12.1,	10.4,	9.4,	8.8,	8.1,	8.4,	8.9,	9.4,	9.7,	9.8,	
		800,	13.4,	11.2,	10.1,	9.4,	8.7,	8.8,	9.2,	9.7,	10,		10.1,	
		900,	16.2,	11.8,	10.8,	10.2,	9.2,	9.2,	9.6,	10,		10.3,	10.4,	
		1000,	17.2,	12.5,	11.5,	10.6,	9.7,	9.6,	9.9,	10.3,	10.6,	10.6,	
		2000,	26.3,	19.4,	19,		16.1,	14.7,	13.4,	12.9,	13,		13.2,	13.1,	
		3000,	29.3,	25.3,	22.4,	20.6,	18.8,	17.2,	16.1,	15.3,	14.9,	15.2,	
		4000,	39.1,	44.2,	27.2,	24.4,	23.1,	20.8,	19.5,	18.5,	17.5,	17.2,	
		5000,	41.7,	49.4,	30.8,	28.1,	25.8,	24,		22.6,	21.4,	20.6,	19.4,	
		6000,	45,		53.4,	35.4,	32.5,	29.2,	27.1,	25.6,	24.3,	23.2,	22.5,	
		7000,	48.1,	54.3,	40.7,	37.1,	32.9,	30.3,	28.4,	27.1,	25.9,	24.9,	
		8000,	50.8,	55.7,	44.6,	40.5,	35.7,	33.5,	31.5,	30.3,	28.7,	27.4,	
		9000,	50.7,	57.6,	48.7,	41.8,	39.7,	36.2,	34.6,	33.3,	31.6,	30,		
		10000,	53.9,	55.5,	47.4,	45.4,	41.5,	39.3,	37.5,	36.2,	34.3,	32.6,	
		11000,	57.2,	58.3,	50.9,	49.1,	47.1,	43,		40.6,	38.5,	36.7,	35,		
		12000,	65.6,	61.4,	54.6,	54.9,	50.9,	46.2,	43.1,	41.2,	38.8,	37.4,	
		13000,	63.8,	64.6,	58.9,	56.5,	54.1,	51.3,	46.5,	43.9,	41.1,	39.8,	
		14000,	62.3,	69.4,	62.1,	61.9,	54.6,	51.8,	50,		46.6,	43.7,	42.2,	
		15000,	65.7,	70.7,	65.4,	65.3,	62,		58.8,	56,		49.6,	45.8,	44.6,	
	},

	MidTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	9.8,	10.5,	11.1,	13.7,	17.9,	26.3,	27.1,	34.1,	34.5,	32.1,	
		500,	11,		9.1,	11.1,	14.1,	20.1,	26.8,	31.8,	35.2,	37.9,	60.4,	
		600,	12.3,	10,		11.9,	14.3,	17.7,	27.3,	32.3,	32.3,	38.1,	40,		
		700,	14.9,	10.8,	12.4,	14.8,	18.3,	28.3,	32.8,	36.1,	38.5,	40,		
		800,	15.7,	11.5,	12.9,	15.3,	18.4,	28.8,	33.3,	36.6,	39,		40,		
		900,	17.2,	12.8,	13.7,	15.8,	18.6,	29.9,	33.8,	37.1,	39.6,	40,		
		1000,	18.1,	14.8,	14.5,	16.2,	19.1,	30.2,	34.3,	37.6,	40.6,	40,		
		2000,	27.4,	20.6,	27.2,	19.4,	30.6,	36.6,	40.9,	43.3,	43.1,	39.9,	
		3000,	33.1,	25.3,	26.4,	32.1,	37.9,	42.6,	44.8,	39.3,	36.7,	39.6,	
		4000,	38.8,	48.9,	29.1,	37.4,	41,		47.3,	46.9,	39.8,	37.3,	40.9,	
		5000,	43,		53.1,	48,		39.1,	47.9,	52.1,	52.4,	49.6,	44.2,	41.3,	
		6000,	45.9,	54.7,	48.8,	39.2,	50.6,	53.1,	55.7,	54.8,	50.8,	44.7,	
		7000,	49.8,	56.8,	60.5,	41,		54.7,	53.8,	58.4,	54.4,	50.1,	46.1,	
		8000,	58.9,	59.9,	60,		43.8,	53,		55,		53,		48.2,	45,		48.5,	
		9000,	63.8,	68,		66.5,	62.7,	52.9,	56.4,	54.2,	49.6,	46.7,	50.6,	
		10000,	66.5,	71.2,	73.2,	58.6,	56,		57.7,	57.4,	51.5,	48,		51.9,	
		11000,	65.9,	73.3,	74.2,	62.3,	54.9,	56.1,	62.1,	61.9,	56.4,	53.8,	
		12000,	71.6,	73.2,	77,		76.6,	54.8,	56.7,	61.5,	65.9,	73.1,	77.2,	
		13000,	73.4,	78,		79.7,	79.5,	55.7,	56.7,	60.7,	66.8,	73.3,	79.8,	
		14000,	78.3,	79.3,	81.1,	80.4,	57.9,	57.5,	59.8,	65.7,	72.9,	79.9,	
		15000,	82,		81.9,	83.1,	81.2,	61.5,	58.1,	59.7,	66.5,	75.5,	81.5,	
	},
	
	warhead	= predefined_warhead("BLU_109"),
	
	fm =
    {
		mass			= 970.0,
		caliber			= 0.368,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.368,
		I				= 592.5,
		I_x				= 32.5,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.066, 0.036},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		finsTau			= 0.1,
		Sw				= 0.1*5,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 1.5,
		Mw_x			= 6.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 890.0,
		Ka					= 12.0,
		Tc					= 0.1,
		Kx					= 0.4,
		Krx					= 4.0,
		gload_limit			= 3.0,
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.1 / 970,
		KDI					= 0.6 * 970 / 0.5,
		KLM					= 1.3 * 0.1 * 5 / 970,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_31_V_4B",
			file		= "GBU31_V_3B_BLU109",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-31(V)4/B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.5,
	}
}

declare_weapon(GBU_31_V_4B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU_31_V_4B}",
	attribute		= GBU_31_V_4B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_31_V_4B.Cx,
	Picture			= "GBU-31V3B.png",
	displayName		= _("GBU-31(V)4/B - JDAM, 2000lb GPS Guided Penetrator Bomb"),
	Weight			= GBU_31_V_4B.mass,
	Elements  		= {{ShapeName = "GBU31_V_3B_BLU109"}},
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_PGM_TAILONLY_USN")
})

GBU_32_V_2B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, WSTYPE_PLACEHOLDER},
    type    = 6,
    mass    = 467.0,
    hMin    = 400.0,
    hMax    = 15000.0,
    Cx      = 0.00035,
    VyHold  = -100.0,
    Ag      = -1.23,
	
	name			= "GBU_32_V_2B",
	model			= "GBU-32",
	user_name		= _("GBU-32(V)2/B"),
	display_name_short = "GBU-32",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	

	encyclopediaAnimation = {
		args = {
			[57] = 1
		}
	},
	
	LaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1050,	1790,	3120,	5280,	9080,	13160,	15980,	16000,	16020,	16040,	
		500,	1120,	1300,	3280,	5450,	8330,	13460,	16200,	16220,	18970,	18990,	
		600,	980,	1550,	3380,	5570,	8700,	13760,	16670,	18870,	19800,	21690,	
		700,	1390,	1600,	3480,	5720,	8850,	14070,	16510,	16530,	16560,	22020,	
		800,	1500,	1650,	3625,	5900,	8800,	14350,	17250,	19450,	21250,	23000,	
		900,	1575,	1775,	3775,	5950,	8925,	14625,	17525,	19725,	21525,	23300,	
		1000,	1675,	1875,	3925,	5825,	9050,	14950,	17850,	20025,	21850,	23600,	
		2000,	2400,	3700,	5475,	7075,	14050,	17675,	20625,	22875,	24750,	26625,	
		3000,	3650,	4050,	7650,	11650,	16250,	20200,	23250,	25600,	27600,	29600,	
		4000,	4700,	6300,	7900,	13150,	18350,	22550,	25800,	28300,	30400,	32600,	
		5000,	4700,	7200,	8500,	15000,	20100,	24700,	28200,	30800,	33100,	35600,	
		6000,	7000,	8250,	11000,	14000,	21500,	26500,	30250,	33250,	36000,	38500,	
		7000,	8500,	9750,	10250,	16750,	22750,	28000,	32250,	35500,	38500,	41250,	
		8000,	9750,	11000,	12750,	17500,	23750,	29500,	34250,	37750,	41000,	44500,	
		9000,	11500,	12750,	14000,	15000,	24250,	30500,	35500,	39750,	43750,	46750,	
		10000,	13000,	14250,	15750,	18500,	24750,	31250,	36750,	41750,	46000,	50250,	
		11000,	14500,	15500,	17000,	19000,	24500,	31500,	38000,	43000,	48000,	53000,	
		12000,	16000,	17500,	19000,	20500,	25000,	31500,	38500,	44500,	50000,	55500,	
		13000,	18000,	19500,	21000,	22500,	25000,	31500,	38500,	46000,	52000,	58000,	
		14000,	20000,	21500,	23000,	24000,	26000,	31500,	39000,	46500,	54000,	60000,	
		15000,	22000,	23000,	24500,	26000,	27500,	31500,	39000,	47000,	55000,	62000,	
	},

	MinLaunchDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	990,	940,	1180,	1440,	1870,	2470,	2990,	3290,	3560,	3870,	
		500,	760,	980,	1260,	1540,	1880,	2510,	3000,	3300,	3750,	4040,	
		600,	790,	1050,	1340,	1610,	1970,	2580,	3090,	3540,	3890,	4310,	
		700,	840,	1100,	1390,	1690,	2040,	2660,	3150,	3470,	3780,	4460,	
		800,	1250,	1150,	1450,	1750,	2100,	2725,	3250,	3750,	4200,	4650,	
		900,	900,	1175,	1500,	1800,	2125,	2775,	3350,	3850,	4300,	4775,	
		1000,	925,	1200,	1525,	1825,	2200,	2850,	3425,	3925,	4425,	4900,	
		2000,	1725,	1300,	1700,	2025,	2625,	3175,	3775,	4500,	5200,	5875,	
		3000,	1750,	1650,	1550,	2100,	2550,	3100,	3750,	4500,	5450,	6400,	
		4000,	2100,	4150,	2100,	2600,	3150,	2800,	3400,	4150,	5200,	6550,	
		5000,	2000,	4300,	2300,	2800,	3300,	3800,	4300,	4900,	4500,	6100,	
		6000,	2000,	2500,	2500,	3000,	3500,	4000,	4500,	5000,	6000,	5250,	
		7000,	1750,	3250,	2500,	2750,	3500,	4000,	4500,	5250,	6000,	5000,	
		8000,	1750,	3000,	2500,	3000,	3500,	4250,	4750,	5500,	6500,	7750,	
		9000,	1500,	2750,	2750,	2750,	3500,	4250,	4750,	5750,	7000,	8250,	
		10000,	1250,	2750,	2500,	3000,	3500,	4250,	4750,	5750,	7250,	8750,	
		11000,	1000,	2000,	2500,	3000,	3000,	4000,	5000,	6500,	7500,	9500,	
		12000,	1500,	2500,	2500,	3000,	3000,	4000,	5000,	6500,	8000,	10500,	
		13000,	1500,	2000,	2500,	3000,	3000,	4000,	5000,	6500,	8500,	11000,	
		14000,	1500,	1500,	2500,	2500,	3500,	4000,	5000,	7000,	9500,	12500,	
		15000,	1500,	1500,	2500,	3000,	3500,	4000,	5000,	7000,	10500,	13500,	
	},

	AspectDistData =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	2,		5,		15,		19,		25,		31,		37,		43,		21,		32,		
		500,	9,		11,		15,		19,		25,		32,		40,		44,		28,		41,		
		600,	9,		15,		14,		21,		25,		23,		40,		42,		43,		43,		
		700,	10,		17,		16,		20,		25,		33,		39,		45,		45,		42,		
		800,	4,		18,		13,		20,		27,		33,		39,		43,		45,		44,		
		900,	14,		20,		16,		22,		26,		34,		39,		43,		45,		45,		
		1000,	16,		21,		14,		20,		27,		34,		40,		44,		45,		45,		
		2000,	13,		32,		23,		39,		34,		39,		44,		45,		45,		45,		
		3000,	19,		45,		32,		40,		41,		44,		45,		45,		45,		45,		
		4000,	36,		10,		45,		44,		44,		45,		45,		45,		45,		45,		
		5000,	43,		21,		45,		45,		45,		45,		45,		45,		45,		45,		
		6000,	45,		25,		17,		45,		45,		45,		45,		45,		45,		45,		
		7000,	45,		36,		24,		45,		45,		45,		45,		45,		45,		45,		
		8000,	45,		43,		27,		45,		45,		45,		45,		45,		45,		45,		
		9000,	45,		45,		41,		45,		45,		45,		45,		45,		45,		45,		
		10000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		11000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		12000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		13000,	45,		45,		45,		45,		45,		31,		45,		45,		45,		45,		
		14000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		15000,	45,		45,		45,		45,		45,		45,		24,		45,		45,		45,		
	},

	MaxTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	12.1,	16.8,	19.5,	24.7,	53.6,	50.1,	56.2,	55.8,	46.1,	42.8,	
		500,	13.5,	9.6,	19.6,	27.9,	34.5,	51.2,	56.8,	50.7,	58.4,	55,		
		600,	11.3,	11.8,	21.8,	31.4,	43.4,	52.3,	58.8,	63.3,	61.9,	65.4,	
		700,	16.6,	12.3,	21.8,	33,		42.9,	53.4,	57.4,	57.4,	48,		66.5,	
		800,	18.1,	12.5,	23.5,	32.1,	43.2,	54.4,	60.8,	65.2,	68.4,	71,		
		900,	19.1,	13.5,	24.3,	30.6,	41,		55.4,	61.7,	66.1,	69.3,	72,		
		1000,	20.4,	14.4,	33.7,	29.8,	43.2,	58.8,	62.9,	67.1,	70.4,	72.9,	
		2000,	29.3,	35.6,	47,		37.2,	65.4,	67,		72.4,	77,		83.6,	88.4,	
		3000,	42.9,	40.8,	47.9,	61.1,	72.6,	75.6,	81.2,	86,		92.6,	96.6,	
		4000,	53.1,	60.9,	59.3,	64.3,	78.3,	83.9,	90.5,	95.2,	101.2,	105.4,	
		5000,	46.9,	63.7,	67.3,	81.3,	83.3,	91.3,	98.4,	102.8,	109.4,	114.1,	
		6000,	61.7,	68.2,	88.8,	65.8,	91.1,	97.9,	105.3,	110.4,	118.9,	122,	
		7000,	71.6,	76.9,	86,		107.9,	98.4,	101.5,	110.9,	117,	125.4,	129.2,	
		8000,	76.2,	81.9,	74.4,	116.2,	103.9,	106.9,	118.5,	124,	132.3,	138.1,	
		9000,	83.4,	87.4,	90.8,	59.2,	103.3,	109.6,	121.6,	130.7,	141.8,	144.3,	
		10000,	89.1,	92.4,	99.1,	85.1,	96.1,	111.6,	125.1,	137.2,	145.7,	148.8,	
		11000,	94.2,	94.7,	101,	91.4,	120.3,	110.7,	127.3,	141.4,	148.6,	152.2,	
		12000,	98.8,	102.7,	108.7,	111.7,	96.4,	109,	121.7,	142.2,	150.3,	156.5,	
		13000,	106.8,	110,	115.4,	120,	97.2,	108.2,	126.4,	141.6,	151.7,	161.1,	
		14000,	114.1,	116.7,	121.3,	122,	113.1,	108.3,	125.6,	139.9,	158,	164.6,	
		15000,	121,	119.3,	122.7,	127.2,	128.8,	109.2,	124.8,	142.7,	158.7,	169.1,	
	},

	MinTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.8,	7.5,	6.9,	6.4,	6.6,	7.4,	7.9,	7.9,	7.8,	7.7,	
		500,	9.3,	8.4,	7.7,	7.1,	6.9,	7.6,	8,		8,		8.3,	8.1,	
		600,	10.3,	9.3,	8.4,	7.7,	7.5,	7.9,	8.3,	8.6,	8.6,	8.8,	
		700,	11.1,	10.1,	9.1,	8.4,	7.9,	8.3,	8.6,	8.5,	8.5,	9.1,	
		800,	15.9,	10.9,	9.8,	9,		8.4,	8.7,	9,		9.3,	9.5,	9.6,	
		900,	12.8,	11.7,	10.5,	9.7,	8.9,	9,		9.4,	9.6,	9.8,	9.9,	
		1000,	13.5,	12.4,	11.1,	10.2,	9.4,	9.4,	9.7,	9.9,	10.2,	10.3,	
		2000,	27.1,	19.2,	17.3,	15.6,	14.1,	13.1,	12.7,	12.8,	13,		13.2,	
		3000,	33.4,	24.6,	24.4,	20.3,	18.5,	17,		15.9,	15.3,	15.3,	15.6,	
		4000,	38.8,	45.7,	26.7,	23.9,	21.9,	21.3,	19.6,	18.4,	17.7,	17.7,	
		5000,	41.8,	50.6,	31.1,	27.4,	25.4,	23.6,	22.3,	21.3,	21.2,	19.8,	
		6000,	45,		45,		35.2,	31,		28.6,	26.8,	25.4,	24.3,	23.3,	23.7,	
		7000,	49.3,	54.5,	40.1,	36.6,	32.1,	30.1,	28.5,	27.2,	26.1,	30.8,	
		8000,	51.8,	56.4,	44.9,	39.7,	36.2,	33,		31.4,	30.1,	28.9,	27.9,	
		9000,	56.1,	59.5,	47.9,	45.3,	40.1,	36.2,	34.6,	33,		31.6,	30.5,	
		10000,	60.3,	61.4,	54,		48.1,	44,		39.3,	37.7,	36.1,	34.5,	33.2,	
		11000,	64.1,	68,		58.1,	52.2,	51,		42.9,	40.6,	38.6,	37.4,	35.8,	
		12000,	61.2,	62.2,	62.1,	55.9,	51.9,	47.9,	43.8,	41.8,	40.2,	38.3,	
		13000,	61.9,	65.8,	59,		59.3,	58.6,	49.2,	49.1,	45.2,	43,		40.9,	
		14000,	64.5,	75.1,	62.7,	60.8,	57.7,	56.8,	52.4,	48,		45.4,	43.2,	
		15000,	65.8,	72,		66.3,	63.2,	63,		59.9,	54.5,	54.2,	47.7,	45.5,	
	},

	MidTOF =
	{
		21,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.9,	9.7,	11.1,	14.3,	20.1,	25.3,	28.3,	26.2,	24.6,	23.1,	
		500,	10.6,	8.7,	11.9,	14.8,	18.2,	25.8,	28.7,	26.7,	29.4,	27.6,	
		600,	10.7,	9.9,	12.2,	14.9,	19.3,	26.9,	29.7,	31.3,	30.9,	32.2,	
		700,	13.3,	10.6,	12.7,	15.6,	19.8,	27.3,	29.2,	27.2,	25.5,	32.8,	
		800,	16.8,	11.2,	13.4,	16.2,	19.7,	27.6,	30.6,	32.3,	33.6,	34.4,	
		900,	16.3,	12,		14,		16.3,	19.6,	28.1,	31,		32.8,	34.1,	35.1,	
		1000,	17.5,	12.7,	14.5,	15.9,	20,		29.4,	31.5,	33.7,	34.6,	35.7,	
		2000,	27.8,	20.4,	20.9,	20,		32.5,	35,		37.3,	38.8,	40,		40.7,	
		3000,	34.5,	28.1,	28.5,	32,		37.3,	40,		42,		43.1,	44.4,	45.7,	
		4000,	40,		51.8,	32.7,	39.6,	43.7,	43.7,	45,		46.3,	48.3,	49.2,	
		5000,	43.7,	55.9,	34.5,	46.9,	47.9,	50.2,	51.2,	51.9,	51,		52.4,	
		6000,	48.1,	55.9,	49.1,	43,		52.6,	54,		55.6,	55.3,	57.1,	54.4,	
		7000,	51.4,	59.2,	56.2,	53.3,	55,		56.9,	58.9,	60.7,	59.9,	56.1,	
		8000,	54.3,	61,		51.2,	58.6,	58,		60.9,	62.2,	64.2,	62.6,	64.6,	
		9000,	67.2,	63.6,	73.3,	47.2,	59,		63.1,	63.1,	64.7,	66.4,	66,		
		10000,	71.5,	76.1,	76,		62.9,	59.1,	61.7,	65.7,	69.1,	69.1,	70.5,	
		11000,	74,		75.6,	78.3,	63.9,	56.6,	62.4,	68.1,	70.5,	70.5,	73.2,	
		12000,	79.2,	81.1,	81.8,	82.6,	57.8,	61.5,	66.4,	69.5,	73,		76,		
		13000,	84.8,	84,		85.1,	86.9,	58.4,	60.9,	65.5,	71.1,	74.1,	77.5,	
		14000,	80.1,	85.6,	88.8,	85.1,	61.8,	60.5,	65.5,	71.9,	77.4,	80.1,	
		15000,	84.8,	88,		88.4,	87.8,	65.1,	61.1,	64.9,	71,		77.9,	83,		
	},

	fuze = specialize_fuze_parameters(
		predefined_fuze("DSU33"),
		{ tdd_position = { 1.43, 0, 0 } }
	),
	
	warhead	= predefined_warhead("Mk_83"),
	
	fm =
    {
		mass			= 467.0,
		caliber			= 0.356,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.356,
		I				= 202.5,
		I_x				= 8.2,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.066, 0.036},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		finsTau			= 0.1,
		Sw				= 0.1*3,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 1.5,
		Mw_x			= 6.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 690.0,
		Ka					= 10.0,
		Tc					= 0.1,
		Kx					= 0.4,
		Krx					= 4.0,
		gload_limit			= 3.0,
		fins_limit			= math.rad(35),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.1 / 467,
		KDI					= 0.6 * 467 / 0.3,
		KLM					= 1.2 * 0.1 * 3 / 467,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_32_V_2B",
			file		= "GBU-32",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-32(V)2/B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.5,
	}
}

declare_weapon(GBU_32_V_2B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU_32_V_2B}",
	attribute		= GBU_32_V_2B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_32_V_2B.Cx,
	Picture			= "GBU32.png",
	displayName		= _("GBU-32(V)2/B - JDAM, 1000lb GPS Guided Bomb"),
	Weight			= GBU_32_V_2B.mass,
	Elements  		= {{ShapeName = "GBU-32"}},
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL_USN")
})


bombs_data =
{
	["GBU-32"] 			= {name = _("GBU-32(V)2/B - JDAM, 1000lb GPS Guided Bomb"), 		mass = GBU_32_V_2B.mass, wsType = GBU_32_V_2B.wsTypeOfWeapon, Cx = GBU_32_V_2B.Cx, picture = "GBU32.png", settings = Get_Combined_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL_USN")},
}


local function bru_55_with_2x(element)
	local bomb_variant = bombs_data[element] or bombs_data["GBU-38"]
	local data = {
		category		=	CAT_BOMBS,
		CLSID			=	"{BRU55_2*"..element.."}",
		Picture			=	bomb_variant.picture,
		wsTypeOfWeapon	=	bomb_variant.wsType,
		displayName		=  _("BRU-55 with 2 x ")..bomb_variant.name,
		attribute		=	{wsType_Weapon,wsType_Bomb,wsType_Container,WSTYPE_PLACEHOLDER},
		Cx_pil			=	0.00244140625 + 2*bomb_variant.Cx,		-- TODO
		Count			=	2,
		Weight			=	bru_33VER_mass + 2*bomb_variant.mass,			-- TODO
		Elements		= {	{ShapeName	= "BRU_55",	IsAdapter  	   = true,	DrawArgs = {{3, 0.2}}	},
							{ShapeName	= element,		connector_name = "Point02"},
							{ShapeName	= element,		connector_name = "Point01"}
		}, -- end of Elements
		settings		= bomb_variant.settings
	}
	declare_loadout(data)
end

bru_55_with_2x("GBU-32")					-- {BRU55_2*GBU-38}


GBU_38_V_1B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, GBU_38},
    type    = 6,
    mass    = 241.0,
    hMin    = 300.0,
    hMax    = 15000.0,
    Cx      = 0.00074,
    VyHold  = -100.0,
    Ag      = -1.23,
	
	name			= "GBU_38",
	model			= "GBU-38",
	user_name		= _("GBU-38(V)1/B"),
	display_name_short = "GBU-38",
	scheme			= "bomb_jdam",
	class_name		= "wAmmunitionChangeableTrajectory",
	

	Reflection		= 0.035,

	LaunchDistData =
	{
		22,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	1000,	1770,	3830,	6670,	7310,	7400,	9560,	9640,	11870,	15370,	
		400,	1180,	1850,	3850,	5150,	5170,	5190,	9110,	14500,	14870,	15680,	
		500,	930,	2010,	4000,	6860,	7900,	7920,	7940,	7960,	7970,	15590,	
		600,	1280,	1900,	4120,	6930,	14240,	15470,	15490,	16820,	17430,	18160,	
		700,	1470,	2000,	4180,	7050,	9820,	9840,	9860,	17410,	17850,	17460,	
		800,	1600,	2250,	4425,	7150,	14950,	17200,	17225,	17425,	17450,	17475,	
		900,	1550,	1900,	4500,	7250,	15350,	17400,	17400,	17425,	17450,	17475,	
		1000,	1525,	2125,	4600,	7325,	13800,	18400,	19325,	21050,	24050,	26700,	
		2000,	2450,	5100,	8750,	13075,	18575,	21925,	24325,	26625,	28500,	30725,	
		3000,	4700,	6600,	11200,	16200,	22100,	25250,	28050,	30550,	32400,	34250,	
		4000,	4650,	7300,	13050,	18550,	24600,	28250,	31450,	34200,	36650,	38350,	
		5000,	6200,	8000,	12500,	20700,	27200,	32000,	35000,	37000,	39500,	41500,	
		6000,	7500,	12500,	15500,	23000,	29750,	35000,	38750,	40750,	42750,	44250,	
		7000,	14000,	15000,	17000,	23750,	31750,	38000,	42000,	44500,	46750,	48750,	
		8000,	16750,	17500,	19500,	25000,	33500,	40250,	45000,	48000,	50500,	53000,	
		9000,	19750,	20500,	21250,	25750,	34750,	42500,	47750,	51250,	54000,	56500,	
		10000,	22250,	23750,	25250,	26750,	35250,	43750,	50250,	54500,	57500,	60500,	
		11000,	25000,	27000,	28500,	30000,	36000,	45000,	52500,	56500,	60500,	64000,	
		12000,	27500,	29000,	31500,	33000,	36000,	45500,	53500,	59000,	63500,	67500,	
		13000,	28000,	31000,	34000,	36000,	38000,	46000,	54500,	61500,	59500,	70500,	
		14000,	29500,	33500,	36000,	39000,	41000,	46000,	55000,	63000,	69000,	73500,	
		15000,	30000,	35000,	38000,	42000,	45000,	45500,	55500,	64500,	71000,	76500,	
	},

	MinLaunchDistData =
	{
		22,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	920,	880,	1150,	1490,	4430,	5760,	6660,	7780,	10410,	10660,	
		400,	1110,	970,	1240,	1470,	1750,	2040,	2600,	3190,	3450,	15200,	
		500,	880,	1040,	1320,	1660,	2010,	2300,	2590,	2850,	3110,	13930,	
		600,	840,	1090,	1390,	1730,	2500,	2900,	3190,	3560,	3880,	14420,	
		700,	880,	1130,	1440,	1790,	2290,	2630,	2940,	3730,	9990,	4340,	
		800,	1300,	1175,	1525,	1825,	2700,	3175,	3525,	3850,	4150,	4500,	
		900,	1375,	1175,	1550,	1875,	2750,	3275,	3625,	3950,	4275,	4650,	
		1000,	925,	1225,	1575,	1925,	2700,	3400,	3850,	4300,	4825,	5375,	
		2000,	1775,	1400,	1875,	2350,	3625,	3975,	4700,	5375,	5975,	6625,	
		3000,	1700,	1050,	1650,	2200,	2900,	4050,	5050,	5950,	6650,	7450,	
		4000,	2300,	4750,	2350,	2850,	3500,	3200,	5050,	6150,	7150,	8050,	
		5000,	2100,	4700,	2400,	3100,	3700,	4500,	4300,	6100,	7300,	8400,	
		6000,	2000,	4500,	2500,	12750,	4000,	4750,	5750,	5250,	7000,	8250,	
		7000,	2000,	2500,	2750,	3250,	4000,	5000,	6000,	3000,	6500,	8500,	
		8000,	2000,	3000,	3000,	3500,	4500,	5000,	5750,	7000,	3500,	7750,	
		9000,	1750,	3000,	3250,	4000,	4750,	5500,	6250,	7250,	3500,	6000,	
		10000,	2000,	3500,	3750,	4250,	5000,	5750,	6750,	7500,	3750,	5000,	
		11000,	2000,	4000,	4500,	4500,	5000,	6000,	7000,	8000,	4000,	4500,	
		12000,	2500,	4000,	4500,	4500,	5500,	6000,	7000,	8500,	4500,	5000,	
		13000,	2500,	4000,	5000,	5500,	5500,	6500,	7500,	9500,	4500,	5500,	
		14000,	2500,	4500,	5500,	5500,	6000,	6500,	8000,	10000,	4500,	6500,	
		15000,	2000,	4500,	6000,	6000,	6500,	7000,	8500,	11000,	5000,	15500,	
	},

	AspectDistData =
	{
		16,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	2,		10,		22,		34,		29,		19,		25,		22,		13,		24,		
		400,	2,		7,		24,		36,		36,		22,		19,		25,		10,		26,		
		500,	10,		7,		25,		33,		42,		25,		29,		19,		13,		26,		
		600,	14,		13,		27,		33,		14,		32,		41,		35,		32,		26,		
		700,	14,		5,		28,		31,		43,		44,		34,		36,		21,		17,		
		800,	3,		7,		25,		34,		20,		36,		17,		36,		26,		17,		
		900,	13,		25,		23,		34,		17,		45,		45,		42,		32,		4,		
		1000,	3,		28,		28,		36,		28,		23,		43,		39,		23,		34,		
		2000,	24,		26,		20,		29,		45,		45,		45,		45,		45,		45,		
		3000,	37,		4,		28,		45,		45,		45,		45,		45,		45,		45,		
		4000,	45,		18,		45,		45,		45,		45,		45,		45,		45,		42,		
		5000,	45,		28,		45,		45,		45,		45,		45,		45,		45,		37,		
		6000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		41,		
		7000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		20,		
		8000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		24,		
		9000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		24,		
	},

	MaxTOF =
	{
		22,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	10.7,	13.9,	24.2,	36.3,	27.7,	23.8,	28.6,	26.5,	31.6,	40.9,		
		400,	12.8,	14,		23.6,	23.2,	18.6,	15.9,	26.8,	43.6,	41.8,	41.8,		
		500,	10.2,	17.9,	25.9,	41.7,	29.5,	25.7,	23,		21,		19.5,	41.3,		
		600,	14.8,	13.8,	26.2,	37.1,	75.2,	65.9,	57.7,	56.6,	53.2,	50.7,		
		700,	16.9,	14.8,	27.4,	37.8,	43.2,	33.2,	29.1,	60.9,	55.5,	47.4,		
		800,	18.4,	17.2,	28.2,	40.1,	74.1,	72.6,	67.3,	60.2,	52.7,	47.4,		
		900,	17.6,	14,		28.7,	40.6,	82.4,	71,		67,		59.5,	50.3,	47.4,		
		1000,	17.9,	16.5,	29.1,	40.3,	71.1,	75.6,	73,		77.3,	87.5,	95,		
		2000,	28.1,	42.7,	56.3,	76.4,	87.7,	87.9,	91.1,	96.4,	101.6,	107.8,	
		3000,	47.1,	57.7,	71.9,	87,		100.6,	99.3,	104.1,	109.8,	115.1,	119.1,	
		4000,	48,		60.1,	84.2,	95.7,	107.6,	109.9,	115.7,	122.1,	129.2,	132.6,	
		5000,	60.7,	72.1,	90.4,	106.2,	115.7,	122.3,	128.1,	130.8,	138,	141.9,	
		6000,	71,		89.5,	85.8,	111.5,	127.2,	133.5,	141,	141.3,	146.4,	148.5,	
		7000,	92.9,	98.3,	102.1,	110.6,	127.7,	143.2,	149,	151.5,	153.2,	152.8,	
		8000,	104.8,	106.2,	124,	117.4,	137.6,	150.8,	159.3,	162,	163.4,	164.2,	
		9000,	116.6,	116.6,	121.9,	120.7,	142.3,	159.8,	168.6,	172.5,	173.5,	172.9,	
		10000,	124.9,	128.6,	142.3,	119.8,	141.9,	162.6,	177.4,	183.6,	183.9,	184.3,	
		11000,	130.9,	135.9,	147.5,	139.2,	146.1,	167.3,	185.8,	187.4,	191.6,	193.1,	
		12000,	132.2,	144.2,	152.4,	161.2,	144.9,	167.2,	185.8,	194.8,	199.8,	202.1,	
		13000,	128.8,	145.3,	153.1,	165.6,	176.3,	169.5,	187.1,	203,	173.2,	209.1,	
		14000,	132.1,	144.8,	153.2,	169.6,	182.8,	170,	187,	206.2,	215.2,	216.8,	
		15000,	131.4,	146.5,	155.4,	173.6,	190.7,	167.5,	188.8,	211.1,	220.3,	225.5,	
	},

	MinTOF =
	{
		22,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	10,		6.5,	6.1,	6.2,	15.7,	18.1,	18.9,	20.6,	26.9,	25.6,		
		400,	12.3,	7.4,	6.8,	6.4,	6.2,	6.2,	6.9,	7.7,	7.6,	40.3,		
		500,	9.9,	8.2,	7.5,	7.2,	7.1,	7,		7,		6.9,	6.9,	35.6,		
		600,	10.1,	9,		8.3,	7.7,	8.8,	8.8,	8.6,	8.7,	8.7,	37.1,		
		700,	10.9,	9.7,	8.8,	8.2,	8.3,	8.2,	8.1,	9.2,	25.3,	8.9,		
		800,	15.6,	10.4,	9.4,	8.7,	9.6,	9.7,	9.6,	9.5,	9.4,	9.3,		
		900,	16.4,	11.1,	10,		9.2,	10,		10.1,	10,		9.9,	9.8,	9.7,		
		1000,	13.2,	11.7,	10.6,	9.7,	10,		10.6,	10.6,	10.8,	11.1,	11.4,		
		2000,	26.2,	18,		15.9,	14.3,	14.5,	13.8,	14,		14.3,	14.6,	14.8,		
		3000,	32,		24.2,	21.1,	18.4,	16.8,	16.3,	16.6,	17,		17.2,	17.5,		
		4000,	38.4,	46.5,	24.5,	22.2,	20.4,	18.9,	18.9,	19.1,	19.6,	19.8,		
		5000,	40.7,	50.4,	28.8,	25.7,	23.6,	22.4,	20.9,	21.3,	21.6,	21.9,		
		6000,	43.6,	54,		32.8,	66.9,	26.8,	25.2,	24.4,	23.1,	23.4,	23.5,		
		7000,	46.2,	45.7,	36.4,	32.3,	29.8,	28.1,	27.1,	28.2,	25.3,	25.8,		
		8000,	48.7,	54.2,	40,		35.6,	32.7,	30.8,	29.4,	29,		30.9,	27.5,		
		9000,	51.7,	55.5,	43.7,	38.6,	35.6,	33.6,	32.2,	31.5,	34.2,	31,		
		10000,	53.2,	55.8,	47,		41.6,	38.4,	36.3,	34.9,	34.1,	37.2,	36.3,		
		11000,	55.2,	58.8,	50.6,	44.3,	41.2,	39,		37.5,	36.9,	40.4,	41.5,		
		12000,	56.5,	59.3,	53.3,	47.4,	43.9,	41.6,	40.1,	39.6,	43.2,	44.5,		
		13000,	59,		61,		56.9,	50.1,	46.6,	44.2,	42.8,	42.3,	47.3,	47.7,		
		14000,	60.8,	63.5,	61.7,	52.7,	49.3,	46.9,	45.4,	44.9,	51.6,	50,		
		15000,	63.1,	65,		66.8,	55.8,	51.9,	49.5,	48.1,	47.6,	55,		45.9,		
	},

	MidTOF =
	{
		22,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	10.3,	9.2,	13,		17.5,	21.8,	21.1,	23.6,	23.6,	29.2,	33.1,		
		400,	12.5,	9.7,	13.5,	13.9,	12,		10.9,	16.3,	23.8,	23,		40.9,		
		500,	10.1,	10.8,	13.9,	17.9,	17.6,	15.7,	14.5,	13.5,	12.8,	38.5,		
		600,	12.1,	11,		14.3,	18.5,	32,		29.9,	27.7,	28,		27.4,	43.6,		
		700,	13.9,	11.4,	14.7,	19,		21.8,	19.4,	18,		29.4,	38.2,	26,		
		800,	17.1,	12.9,	15.6,	18.8,	35.6,	33.6,	30.9,	29.3,	27.8,	26.3,		
		900,	17,		12.1,	16,		19.3,	36.5,	34.6,	31.4,	29.4,	27.9,	26.4,		
		1000,	15.3,	13.2,	16.4,	19.7,	31.8,	37.9,	35,		35.8,	39.7,	41.9,		
		2000,	26.9,	28.5,	34,		38.5,	47.9,	48,		47.4,	48.3,	49.1,	50,		
		3000,	37.3,	32.8,	45.6,	49.3,	55.9,	55.2,	55.4,	57,		56.2,	56.7,		
		4000,	39.1,	51.2,	62.3,	78.7,	65.5,	58.2,	61.1,	63.3,	64.9,	64.3,		
		5000,	43.4,	54,		65.9,	73.3,	71.9,	71.3,	66.2,	67.5,	69.2,	69,		
		6000,	51.4,	75.5,	52.8,	82.3,	79.1,	79.2,	78.4,	72.6,	73,		71.7,		
		7000,	74.4,	75.7,	69,		68.8,	79.9,	86,		86.6,	73.7,	78.7,	77,		
		8000,	86.4,	86.1,	74.7,	67.8,	85.3,	92.1,	92.5,	89.5,	76.2,	80.7,		
		9000,	96.1,	96.7,	92.5,	70,		80.4,	91,		100.7,	94.7,	80.4,	80.4,		
		10000,	102.5,	108,	107.8,	102.9,	117.2,	90,		108,	101.7,	84.5,	82.1,		
		11000,	96,		118.2,	118.7,	112.3,	117.6,	102.9,	114.1,	103.3,	86.8,	84.3,		
		12000,	96.9,	104.5,	126.1,	121.3,	116.9,	104.1,	108.6,	107.4,	92.4,	88,		
		13000,	101,	127.2,	132.7,	132.7,	120.7,	114.8,	109.2,	111.4,	81.8,	90.7,		
		14000,	108.2,	108.1,	136.6,	138.3,	130.1,	102.7,	108,	110.4,	96.1,	95.4,		
		15000,	107,	112.8,	121,	144.5,	146.4,	100.1,	108.5,	116.3,	99.6,	117.2,	
	},

	fuze = specialize_fuze_parameters(
		predefined_fuze("DSU33"),
		{ tdd_position = { 1.09, 0, 0 } }
	),

	warhead	= predefined_warhead("Mk_82"),
	
	fm = {
		mass			= 253.1,
		caliber			= 0.274,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.274/5,
		I				= 65.1,
		I_x				= 2.85,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.04, 0.022},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		Sw				= 0.059*5,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 9.5,
		Mw_x			= 3.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 390.0,
		Ka					= 6.0,
		Tc					= 0.1,
		Kx					= 0.1,
		Krx					= 4.0,
		gload_limit			= 2.5,
		fins_limit			= math.rad(30),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.059 / 253,
		KDI					= 0.6 * 253 / 0.3,
		KLM					= 0.7 * 0.059 * 5 / 253,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_38",
			file		= "GBU-38",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-38(V)1/B"),
			index		= GBU_38,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.45,
	}
}

declare_weapon(GBU_38_V_1B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU-38}",
	attribute		= GBU_38_V_1B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_38_V_1B.Cx,
	Picture			= "GBU38.png",
	displayName		= _("GBU-38(V)1/B - JDAM, 500lb GPS Guided Bomb"),
	Weight			= GBU_38_V_1B.mass,
	Elements  		= {{ShapeName = "GBU-38"}},
	settings		= Get_Combined_GUISettings_Preset("MDRN_B_A_PGM_TWINWELL")
})


GBU_54_V_1B =
{
	category		= CAT_BOMBS,
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, WSTYPE_PLACEHOLDER},
    type    = 4,
    mass    = 253.0,
    hMin    = 400.0,
    hMax    = 15000.0,
    Cx      = 0.00074,
    VyHold  = -100.0,
    Ag      = -1.23,
	
	name			= "GBU_54_V_1B",
	model			= "GBU-54",
	user_name		= _("GBU-54(V)1/B"),
	display_name_short = "GBU-54",
	scheme			= "bomb_jdam_laser",
	class_name		= "wAmmunitionLaserHoming",
	

	Reflection		= 0.035,

	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1090,	1890,	3760,	6310,	7350,	5760,	16090,	16910,	16850,	22820,	
		500,	1240,	1960,	3830,	6140,	8520,	13590,	13990,	13620,	22740,	22790,	
		700,	1000,	2120,	3960,	6680,	9620,	15840,	15840,	16160,	22840,	22840,	
		1000,	1860,	2380,	4380,	6920,	10020,	16100,	20560,	21900,	21920,	26160,	
		2000,	2400,	4850,	4950,	7850,	11300,	20200,	22850,	22900,	22900,	26750,	
		3000,	4550,	5950,	8550,	8600,	12200,	22900,	26650,	26700,	26750,	26750,	
		4000,	3850,	7050,	9350,	9400,	13150,	25750,	25800,	25850,	25900,	30350,	
		5000,	7300,	7400,	11900,	18700,	18800,	28500,	30200,	30300,	30300,	30400,	
		6000,	5600,	7300,	13000,	21100,	20000,	32000,	32000,	32000,	32100,	32200,	
		7000,	6800,	8700,	15400,	15400,	15400,	30500,	30500,	30500,	30700,	47600,	
		8000,	8000,	14200,	18600,	23200,	27200,	36200,	36200,	36200,	36400,	51200,	
		9000,	9200,	16400,	20800,	24200,	31800,	34200,	34200,	34200,	34200,	55000,	
		10000,	15600,	18000,	23200,	26400,	32800,	40200,	42800,	42800,	42800,	59000,	
		11000,	16500,	21000,	25500,	28500,	33500,	41000,	48000,	53500,	58000,	62500,	
		12000,	20000,	23000,	26000,	30500,	34500,	42500,	49500,	56000,	61000,	66500,	
		13000,	27000,	24500,	29000,	33000,	37000,	43000,	51000,	58000,	64500,	70000,	
		14000,	21000,	32000,	35500,	36500,	39000,	44000,	52000,	60000,	67500,	73500,	
		15000,	23000,	33000,	39000,	40000,	42000,	46500,	53000,	61500,	69500,	77000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	1020,	1020,	1290,	1560,	1800,	2050,	2200,	2400,	2600,	2750,	
		500,	1180,	1110,	1400,	1650,	1970,	2510,	2400,	2500,	2750,	2900,	
		700,	1100,	1260,	1580,	1840,	2200,	2840,	3140,	9160,	4060,	4380,	
		1000,	1040,	1400,	1760,	2040,	2420,	3100,	3680,	4040,	4420,	5000,	
		2000,	1250,	1900,	2050,	2450,	2800,	3700,	4400,	5550,	5350,	6150,	
		3000,	2550,	2150,	2150,	2500,	2850,	3800,	4700,	5400,	5950,	6700,	
		4000,	2550,	2250,	1900,	2350,	2700,	3750,	4400,	5400,	6150,	7450,	
		5000,	1400,	1900,	1500,	2300,	2900,	3400,	4000,	5400,	6400,	7500,	
		6000,	1800,	1300,	1600,	2200,	2400,	3200,	3300,	4600,	6200,	7500,	
		7000,	1200,	1300,	1700,	1700,	1700,	2400,	2400,	2400,	5600,	8000,	
		8000,	1200,	1600,	1800,	2000,	2200,	2600,	2600,	2600,	4200,	7800,	
		9000,	1400,	1800,	1800,	2000,	2400,	2600,	2600,	2600,	2600,	7600,	
		10000,	1800,	1800,	2000,	2200,	2400,	3800,	3000,	3000,	3000,	7600,	
		11000,	1500,	2000,	2000,	2000,	2500,	3000,	3000,	3500,	3500,	7500,	
		12000,	1500,	2000,	2000,	2000,	2500,	3000,	3000,	3500,	4000,	7500,	
		13000,	2000,	2000,	2500,	2500,	2500,	3000,	3500,	3500,	4000,	6500,	
		14000,	2000,	2500,	2500,	2500,	2500,	3000,	3500,	3500,	4000,	7500,	
		15000,	2000,	2500,	2500,	2500,	3000,	3000,	3500,	4000,	4000,	10500,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	10.9,	7.6,	7,		6.7,	6.3,	6.2,	5.9,	5.8,	5.7,	5.5,		
		500,	12.6,	8.5,	7.8,	7.3,	7,		7.6,	6.5,	6.2,	6.1,	6.5,		
		700,	13,		10.1,	9.2,	8.5,	8.1,	8.7,	8.5,	24.6,	9.1,	9,		
		1000,	13.4,	12.1,	11,		10,		9.5,	9.9,	10.2,	10.1,	10.1,	10.5,		
		2000,	20,		18.8,	16.3,	14.7,	13.5,	13.3,	13.4,	14.7,	13.2,	13.7,		
		3000,	31.7,	24.5,	21.1,	19,		17.3,	16.3,	16.1,	15.9,	15.7,	15.9,		
		4000,	36.7,	30.8,	25.5,	23.2,	21.4,	19.5,	18.4,	18,		17.8,	18.5,		
		5000,	36.2,	36.2,	30.3,	26.9,	24.6,	22.9,	21.4,	20.4,	20.2,	20.2,		
		6000,	46.1,	41.5,	34.2,	30.5,	29.1,	26.4,	25.4,	23.2,	22.3,	22.1,		
		7000,	50.4,	47.2,	37.5,	35,		34.7,	31.8,	30.5,	30.7,	24.7,	24.5,		
		8000,	52.6,	54.2,	41.4,	37.9,	36.3,	34.6,	33,		32.3,	29,		26.4,		
		9000,	54.3,	58.5,	45.4,	41.4,	38.8,	38.1,	36.6,	35.5,	36.5,	28.8,		
		10000,	53.4,	60.8,	49.8,	44.4,	42.4,	38.2,	38.8,	38,		38.5,	31.6,		
		11000,	56,		62.5,	53.9,	48.9,	45.4,	43.4,	41.9,	40.3,	40.6,	34.6,		
		12000,	57.9,	62.5,	57.7,	52.1,	48.7,	46.8,	45.3,	43.7,	42.9,	37.8,		
		13000,	59,		64,		60.5,	54,		52.3,	50.8,	47.4,	47,		46.8,	43.3,		
		14000,	60.8,	64.4,	64.3,	57.3,	56.4,	54.4,	50.3,	49.9,	51,		45.4,		
		15000,	62.6,	66,		67.6,	61.1,	58.2,	57.9,	53.8,	52.8,	55.5,	44.7,		
	},

	AspectDistData =
	{
		15,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,	
		400,	2,		9,		14,		23,		20,		20,		20,		24,		13,		10,
		500,	2,		10,		15,		24,		37,		23,		19,		24,		13,		14,
		700,	4,		10,		16,		24,		38,		29,		32,		32,		20,		18,
		1000,	6,		10,		17,		26,		38,		26,		33,		34,		36,		38,
		2000,	8,		10,		24,		29,		38,		20,		28,		34,		45,		45,
		3000,	10,		20,		24,		32,		40,		15,		22,		34,		45,		45,
		4000,	12,		20,		24,		33,		40,		15,		45,		36,		45,		45,	
		5000,	14,		20,		36,		40,		40,		40,		45,		36,		45,		45,	
		6000,	16,		18,		40,		40,		42,		45,		45,		36,		45,		45,	
		7000,	18,		38,		45,		35,		45,		45,		45,		45,		45,		45,	
		8000,	20,		22,		35,		35,		45,		45,		45,		45,		45,		35,	
		9000,	20,		22,		28,		28,		43,		45,		45,		45,		45,		35,	
		10000,	20,		22,		28,		33,		42,		45,		45,		45,		45,		35,	
		11000,	20,		22,		28,		34,		36,		38,		45,		45,		45,		45,	
		12000,	16,		21,		27,		33,		36,		38,		45,		45,		45,		45,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.4,	14.2,	24.8,	33.7,	27.6,	17.8,	65.9,	53.1,	49,		84.5,		
		500,	13,		15.8,	26,		28.6,	34.1,	48.8,	50.7,	39.8,	90.1,	63.7,		
		700,	11.3,	16.5,	24.6,	36.9,	46.1,	74.1,	62.7,	49.2,	72.7,	69.6,		
		1000,	19.3,	19.5,	29.1,	36.7,	49.4,	77.6,	88.3,	86.4,	84.8,	83.6,		
		2000,	26.3,	38.2,	30.7,	42.1,	55.9,	91,		91.7,	89.5,	84.3,	88.3,	
		3000,	40.2,	46.1,	59.7,	47.4,	57.6,	99.1,	108,	103.4,	116.7,	92.6,		
		4000,	38.1,	53.3,	60.6,	52.8,	62,		109.4,	99.7,	117.7,	91.9,	98.1,	
		5000,	57.2,	54.7,	78.1,	104,	100.2,	120.2,	117.1,	120.2,	136.6,	100,	
		6000,	53.6,	54.8,	83.2,	104.8,	103.7,	142.7,	122,	124.1,	142,	103,	
		7000,	60.8,	69,		93.8,	80.1,	73.1,	120.8,	119.1,	138.3,	102.3,	158.1,	
		8000,	67.7,	102.8,	109,	110.5,	134.5,	134.1,	143.5,	154.1,	156.8,	158.9,	
		9000,	74,		97.7,	119,	115.3,	131.1,	137.7,	135.6,	153.9,	109.5,	168.9,	
		10000,	107.1,	103.7,	126.3,	132,	134.8,	150.8,	151.4,	179.9,	173.6,	179.7,	
		11000,	110.7,	118.7,	133.9,	138.8,	136.9,	151.1,	166.9,	177.4,	182.1,	187.2,	
		12000,	123.1,	127.6,	136.9,	142.4,	132.3,	158.5,	170.2,	184.1,	188.9,	197.4,	
		13000,	128.2,	136,	143,	148.8,	159.8,	158.9,	174.9,	188,	199,	204.7,	
		14000,	135.4,	163.9,	155.1,	160,	161.7,	165,	177.7,	193.5,	206.8,	212.5,	
		15000,	145,	173.8,	163.8,	166.4,	170,	180.5,	182.6,	197.6,	209.5,	221.3,	
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		400,	11.1,	10,		13,		16.5,	15.9,	11.7,	41.6,	45.5,	38.3,	55.6,		
		500,	12.7,	10.8,	13.6,	16.2,	18.4,	26.1,	37.4,	22.1,	50.6,	49.1,		
		700,	11.2,	12.7,	14.4,	17.7,	20.8,	30.9,	28,		36.2,	6.2,	34.4,		
		1000,	16.7,	14.4,	16.5,	18.4,	22.1,	31.9,	37.7,	37.1,	34.9,	40.3,		
		2000,	20.7,	31.5,	20.2,	22.8,	25.6,	42.3,	43.2,	41.1,	37.4,	45.5,		
		3000,	36.3,	27.2,	33.9,	25.3,	28,		48.1,	51.9,	46.9,	44.1,	42,		
		4000,	36.8,	41.7,	37.6,	28.6,	30.2,	53.9,	46.6,	44.7,	42.5,	54.5,		
		5000,	45.9,	34.2,	52.4,	75.1,	42.3,	58.1,	54.7,	51.5,	49.5,	47.2,		
		6000,	44,		36.4,	55.5,	92.5,	44.1,	66.5,	55.6,	52.7,	51,		48.8,		
		7000,	47,		52.2,	56,		43.6,	36.5,	58.3,	51.3,	46.1,	47.3,	73.9,		
		8000,	49.6,	64,		65.1,	76.9,	62.9,	73.9,	61.5,	55.1,	52.9,	76.8,		
		9000,	54.5,	68.9,	79.2,	69,		91.4,	65.6,	56.2,	52.1,	47.7,	79.4,		
		10000,	69.3,	71.3,	83.3,	89,		83.9,	86.5,	71.5,	64.7,	58.6,	83.5,		
		11000,	70.1,	78.1,	86.4,	90.9,	82.6,	80.8,	82,		84.5,	81.6,	86.5,		
		12000,	78,		80.8,	84.6,	92.4,	83.3,	83.3,	82.1,	85.6,	84.7,	89.4,		
		13000,	102.7,	82.6,	89.3,	95.2,	95.3,	81.4,	83.9,	88.2,	88.8,	90.2,		
		14000,	78,		105.5,	105.4,	99.6,	95.5,	83.8,	84,		89.3,	91.2,	94,		
		15000,	81.5,	103.2,	112,	103.3,	100,	90.2,	85.3,	90.5,	91.4,	101,	
	},
	
	warhead	= predefined_warhead("Mk_82"),
	
	fm = {
		mass			= 253.1,
		caliber			= 0.274,
		cx_coeff		= {1, 0.45, 0.8, 0.15, 1.55},
		L				= 0.274/5,
		I				= 65.1,
		I_x				= 2.85,
		wind_time		= 0.0,
		wind_sigma		= 0.0,
		dCydA			= {0.04, 0.022},
		A				= 0.6,
		maxAoa			= math.rad(25),
		finsTau			= 0.1,
		fins_gain		= 100,
		ideal_fins 		= 1,
		Sw				= 0.059*5,
		Ma				= 6.3,
		Mw				= 3.0,
		Ma_x			= 9.5,
		Mw_x			= 3.5,
		model_roll 		= math.rad(-45),
    },
	
	seeker = {
		CEP 					= 5.0,
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
	},
	
	laser_seeker = {
		delay				= 2.0,
		FOV					= math.rad(35),
		max_seeker_range	= 4500,
	},
	
	autopilot = {
		delay				= 1.0,
		op_time				= 9000,
		Tf					= 0.05,
		Knav				= 3.0,
		Kd					= 390.0,
		Ka					= 6.0,
		Tc					= 0.1,
		Kx					= 0.1,
		Krx					= 4.0,
		gload_limit			= 2.5,
		fins_limit			= math.rad(30),
		fins_limit_x		= math.rad(5),
		null_roll			= math.rad(-45),
		KD0					= 0.059 / 253,
		KDI					= 0.6 * 253 / 0.3,
		KLM					= 0.7 * 0.059 * 5 / 253,
	},
	
	shape_table_data =
	{
		{
			name		= "GBU_54_V_1B",
			file		= "GBU-54",
			life		= 1,
			fire		= {0, 1},
			username	= _("GBU-54(V)1/B"),
			index		= WSTYPE_PLACEHOLDER,
		},
	},
	
	targeting_data = 
	{
		char_time		= 20.5,
	}
}

declare_weapon(GBU_54_V_1B)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{GBU_54_V_1B}",
	attribute		= GBU_54_V_1B.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= GBU_54_V_1B.Cx,
	Picture			= "GBU54.png",
	displayName		= _("GBU-54(V)1/B - LJDAM, 500lb Laser & GPS Guided Bomb LD"),
	Weight			= GBU_54_V_1B.mass,
	Elements  		= {{ShapeName = "GBU-54"}},
	settings		= Get_Fuze_GUISettings_Preset("MDRN_B_A_PGM_TAILONLY")
})


LS6_100 =
{
    category        = CAT_BOMBS,
    wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Guided, WSTYPE_PLACEHOLDER},
    type            = 4,
    mass            = 6.5,
    hMin            = 400.0,
    hMax            = 15000.0,
    Cx              = 0.00001,
    VyHold          = -100.0,
    Ag              = -1.23,

    name            = "LS_6_100",
    model           = "ls-6-100",
    user_name       = _("LS-6-100"),
    scheme          = "bomb_jdam_laser",
    class_name      = "wAmmunitionLaserHoming",

    shape_table_data =
    {
        {
            name        = "LS_6_100",
            file        = "ls-6-100",
            life        = 1,
            fire        = {0, 1},
            username    = _("LS-6-100"),
            index       = WSTYPE_PLACEHOLDER,
        },
    },

	LaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		7900,	8000,	7900,	9500,	9500,	9600,	16900,	
		500,	0,		0,		7700,	10900,	13000,	14100,	15000,	15700,	16600,	18000,	
		700,	0,		0,		8500,	12400,	14100,	14800,	15200,	15200,	15200,	18400,	
		1000,	0,		0,		9600,	14200,	18200,	18200,	18200,	18200,	18200,	18800,	
		2000,	0,		8400,	13600,	19200,	24600,	27800,	29400,	30200,	30800,	31600,	
		3000,	0,		11000,	16800,	23400,	29400,	32800,	34400,	35400,	36000,	36800,	
		4000,	9500,	13000,	19500,	27000,	33500,	37500,	39000,	40000,	41000,	41500,	
		5000,	11500,	15500,	22500,	30500,	38000,	42000,	43500,	44500,	45500,	46500,	
		6000,	13000,	18000,	25000,	34000,	42000,	46000,	48000,	49000,	50000,	51000,	
		7000,	16500,	21000,	27500,	37000,	45500,	50000,	52500,	53500,	54500,	56000,	
		8000,	23250,	23250,	29250,	39000,	48750,	53250,	56250,	57750,	59250,	60750,	
		9000,	27750,	27750,	30750,	41250,	51750,	57750,	60750,	61500,	63000,	64500,	
		10000,	31500,	31500,	33750,	43500,	54000,	60750,	63750,	66000,	67500,	69000,	
		11000,	34500,	36000,	37500,	45000,	56250,	63000,	67500,	69000,	71250,	73500,	
		12000,	36000,	39000,	41000,	47000,	58000,	66000,	70000,	73000,	75000,	77000,	
		13000,	36000,	42000,	45000,	48000,	60000,	68000,	74000,	77000,	78000,	81000,	
		14000,	37000,	46000,	48000,	51000,	62000,	71000,	77000,	80000,	83000,	85000,	
		15000,	38000,	48000,	50000,	55000,	64000,	74000,	80000,	83000,	86000,	88000,	
	},

	MinLaunchDistData =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		7600,	7900,	7600,	7700,	8100,	8700,	13500,	
		500,	0,		0,		7600,	7800,	8000,	8100,	8200,	8300,	8400,	17000,	
		700,	0,		0,		7600,	8000,	8100,	8200,	8200,	8200,	8200,	13800,	
		1000,	0,		0,		7600,	8000,	8400,	8400,	8400,	8400,	8400,	8600,	
		2000,	0,		7600,	8000,	8600,	9000,	9400,	9400,	9600,	9600,	9600,	
		3000,	0,		7800,	8400,	9000,	9400,	9800,	10000,	10000,	10000,	10200,	
		4000,	8000,	8000,	9000,	9500,	10000,	10500,	10500,	10500,	10500,	11000,	
		5000,	8000,	8500,	9000,	10000,	10500,	11000,	11000,	11000,	11000,	11000,	
		6000,	8000,	8500,	9500,	10000,	11000,	11000,	11500,	11500,	11500,	11500,	
		7000,	8500,	9000,	9500,	10500,	11000,	11500,	12000,	12000,	12000,	12000,	
		8000,	9000,	9000,	9750,	10500,	11250,	12000,	12000,	12000,	12750,	12750,	
		9000,	9750,	9750,	9750,	10500,	12000,	12000,	12750,	12750,	12750,	12750,	
		10000,	9750,	9750,	10500,	11250,	12000,	12750,	12750,	12750,	13500,	13500,	
		11000,	10500,	10500,	10500,	11250,	12000,	12750,	13500,	13500,	13500,	13500,	
		12000,	10000,	10000,	10000,	11000,	12000,	13000,	13000,	13000,	14000,	14000,	
		13000,	10000,	11000,	11000,	11000,	12000,	13000,	13000,	14000,	14000,	14000,	
		14000,	10000,	11000,	11000,	11000,	12000,	13000,	14000,	14000,	14000,	14000,	
		15000,	10000,	11000,	11000,	12000,	13000,	13000,	14000,	14000,	15000,	15000,	
	},

	MaxTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		42.5,	29.9,	26,		29.2,	27.8,	26.9,	52.8,		
		500,	0,		0,		48.8,	53.6,	53.2,	51.1,	51.2,	51.6,	53.2,	56.5,		
		700,	0,		0,		53.6,	59.4,	57.1,	53.6,	51.8,	49.9,	48.1,	57,		
		1000,	0,		0,		59.3,	68.9,	75.8,	66.6,	62.4,	60.3,	58.7,	58.8,		
		2000,	0,		61.2,	80.1,	94.3,	106.3,	112,	113.9,	113.5,	113.1,	113.8,	
		3000,	0,		78.2,	96.6,	114.2,	126.9,	132.8,	134.1,	134.7,	133.8,	134.1,	
		4000,	94.4,	88.1,	109,	129.5,	142.5,	151.5,	151.6,	151.7,	153,	150.9,	
		5000,	105.6,	105,	125.8,	144.4,	161.3,	168.9,	168.1,	167.8,	168.6,	169.1,	
		6000,	111.4,	121.5,	138.9,	160.3,	177,	182.8,	184.7,	183.7,	183.9,	183.8,	
		7000,	129.6,	142.1,	153.7,	173.1,	189.7,	197.1,	201.3,	199.6,	199.1,	201.4,	
		8000,	146.3,	149.8,	160.9,	178.1,	201.3,	206.7,	213.2,	214,	215.8,	217.2,	
		9000,	156.9,	174.7,	165.9,	187.3,	212.1,	226.1,	230.6,	225.2,	226,	226.4,	
		10000,	162,	186.5,	186.1,	198.8,	218.2,	235.6,	238.3,	241.7,	241.1,	240.3,	
		11000,	164.3,	200.2,	208.1,	204.8,	225.8,	240.2,	251.9,	248.6,	251.4,	254.1,	
		12000,	163,	203.2,	220.1,	218.1,	230.1,	250.1,	256.7,	261.9,	261.8,	261.6,	
		13000,	157.7,	206.5,	230.6,	220.7,	237.3,	253.3,	270.9,	274.9,	267.3,	272,	
		14000,	158.3,	214.1,	232.7,	239.6,	245.7,	264,	278.6,	281.3,	284.9,	282.5,	
		15000,	159.9,	211.3,	230.7,	257.5,	254.4,	275.4,	286.6,	287.9,	290.6,	287.2,	
	},

	MinTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		40.1,	29.3,	24.6,	23.1,	23,		23.7,	38.6,		
		500,	0,		0,		48.2,	40.7,	29,		26.6,	24.6,	23.5,	22.7,	52.9,		
		700,	0,		0,		47.9,	41.5,	30.2,	26.8,	24.6,	23.1,	21.9,	40.5,		
		1000,	0,		0,		51.1,	39.9,	31.4,	27.4,	25.3,	23.6,	22.4,	21.8,		
		2000,	0,		57.7,	52,		40.8,	33.2,	31,		28.6,	27.7,	26.2,	24.8,		
		3000,	0,		54.1,	57.4,	41.7,	35,		32.7,	30.9,	29.2,	27.7,	26.6,		
		4000,	74.4,	55.3,	62.6,	44,		37.5,	35.4,	32.9,	31.1,	29.7,	29.2,		
		5000,	72.2,	49.8,	59.8,	45.7,	39.6,	37.9,	35.3,	33.3,	31.7,	29.9,		
		6000,	59.3,	50.2,	61.6,	45.5,	42.2,	38.6,	37.6,	35.6,	33.9,	31.8,		
		7000,	78.4,	53.3,	58.8,	47.8,	43.1,	41.2,	40.2,	38,		36,		34,		
		8000,	78,		54.7,	59.1,	48.5,	45,		43.8,	41.1,	38.9,	38.8,	36.4,		
		9000,	80.9,	86.1,	59.3,	49.7,	48.5,	44.9,	44.3,	42,		39.8,	37.6,		
		10000,	80.8,	60.9,	63.7,	53.2,	49.7,	48.1,	45.5,	43.3,	42.4,	40,		
		11000,	82,		97.6,	64.4,	54.6,	51.2,	49.5,	48.4,	46.1,	43.7,	41.2,		
		12000,	84.5,	107.9,	63.5,	55.5,	52.8,	51.4,	48.7,	46.5,	45.8,	43.2,		
		13000,	82.5,	107.6,	69.3,	57.4,	54.3,	52.9,	50.2,	49.5,	47,		44.5,		
		14000,	78.6,	94.7,	71,		59.4,	56.1,	54.4,	53.3,	50.8,	48.4,	46,		
		15000,	77.7,	89,		73.4,	63.5,	59.7,	56,		54.7,	52.3,	50.9,	48.5,		
	},

	MidTOF =
	{
		18,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		41.2,	30.2,	25.3,	26.2,	25.4,	25.1,	46.7,		
		500,	0,		0,		48,		46.4,	44.3,	39.6,	36.7,	37.4,	37.5,	54.7,		
		700,	0,		0,		50.1,	50.2,	47.1,	41.1,	38.3,	35.9,	34,		49.5,		
		1000,	0,		0,		52.6,	54.7,	54,		48,		44.7,	42.2,	40,		39.5,		
		2000,	0,		56.2,	64,		65.8,	66.6,	66.8,	66.1,	65.6,	64.8,	64.2,		
		3000,	0,		60.7,	72,		75.1,	75.9,	75.9,	75.5,	74.8,	73.9,	73.3,		
		4000,	77.2,	64.3,	77.6,	83.2,	84.1,	84.8,	84,		83,		82.6,	81.7,		
		5000,	88.8,	71.6,	82.6,	90.5,	92.6,	93.4,	92.1,	91.2,	90.6,	89.6,		
		6000,	91,		77.2,	88.3,	96.2,	100,	99.8,	100,	99.3,	98.5,	96.6,		
		7000,	102.4,	102.6,	84.7,	100.6,	105.6,	106.9,	108,	106.7,	105.6,	104.8,	
		8000,	114.5,	107.9,	88.1,	106.7,	112.5,	113,	113.7,	113.1,	114,	112.7,	
		9000,	122.8,	129.4,	90.7,	106.9,	118.9,	120.1,	121.2,	119.8,	119.6,	117.7,	
		10000,	128.5,	134.7,	99.2,	113.7,	120.5,	124.7,	125.1,	125.3,	125.1,	123.6,	
		11000,	133.4,	142.4,	108.1,	113.4,	126.2,	127.6,	130,	129.5,	128.7,	126.9,	
		12000,	124.3,	146.1,	115.4,	116.3,	129,	131.4,	131,	131.2,	130.9,	130,	
		13000,	127.2,	141.7,	128,	110.4,	129.3,	130.7,	135.1,	136.9,	132.8,	131.3,	
		14000,	125.2,	138.1,	134.4,	116.2,	130.4,	134.7,	140.2,	139.6,	138.5,	134.7,	
		15000,	123.6,	140.1,	137.3,	126.3,	130.3,	138.6,	143.3,	142.4,	142.4,	137.9,	
	},
	
	AspectDistData =
	{
		13,		10,

				100,	150,	200,	250,	300,	350,	400,	450,	500,	550,		
		300,	0,		0,		0,		24,		28,		30,		30,		25,		25,		20,		
		500,	0,		0,		6,		44,		45,		45,		45,		20,		20,		18,		
		700,	0,		0,		16,		40,		45,		45,		45,		45,		45,		40,		
		1000,	0,		0,		24,		45,		45,		45,		45,		45,		45,		42,		
		2000,	0,		27,		42,		45,		45,		45,		45,		45,		45,		42,		
		3000,	0,		42,		45,		45,		45,		45,		45,		45,		45,		45,		
		4000,	33,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		5000,	36,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		6000,	37,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		7000,	38,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		8000,	39,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		9000,	42,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
		10000,	45,		45,		45,		45,		45,		45,		45,		45,		45,		45,		
	},

    fm = {
        mass           = 22.0,
        caliber        = 0.160,
        cx_coeff       = {1, 0.45, 0.8, 0.15, 1.55},
        L              = 0.160/5,
        I              = 26.5,
        I_x            = 0.282,
        wind_time      = 0.0,
        wind_sigma     = 0.0,
        dCydA          = {0.04, 0.022},
        A              = 0.6,
        maxAoa         = math.rad(25),
        finsTau        = 0.1,
        fins_gain      = 100,
        ideal_fins     = 1,
        Sw             = 0.059*5,
        Ma             = 6.3,
        Mw             = 3.0,
        Ma_x           = 9.5,
        Mw_x           = 3.5,
        model_roll     = math.rad(-45),
    },

    seeker = {
        CEP                 = 5.0,
        coalition           = 2,
        coalition_rnd_coeff = 5.0,
    },

    laser_seeker = {
        delay               = 2.0,
        FOV                 = math.rad(35),
        max_seeker_range    = 7000,
    },

    autopilot = {
        delay               = 0.2,
        op_time             = 9000,
        Tf                  = 0.05,
        Knav                = 3.0,
        Kd                  = 390 / 2.8, -- 480
        Ka                  = 6.0 / 2.8, -- 6.0
        Tc                  = 0.1,
        Kx                  = 0.1,
        Krx                 = 4.0,
        gload_limit         = 3.0,
        fins_limit          = math.rad(30),
        fins_limit_x        = math.rad(5),
        null_roll           = math.rad(-45),
        KD0                 = 0.059 / 88.0,
        KDI                 = 0.6 * 88.0 / 0.3,
        KLM                 = 0.7 * 0.059 * 5 / 88.0,
    },

    targeting_data =
    {
        char_time = 20.5,
    },

    warhead = predefined_warhead("LS_6_100"),
}

declare_weapon(LS6_100)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{LS6_100}",
	attribute		= LS6_100.wsTypeOfWeapon,
	Count 			= 1,
	Cx_pil			= LS6_100.Cx,
	Picture			= "mam_c_ap.png",
	displayName		= _("LS-6-100"),
	Weight			= LS6_100.mass,
	Elements  		= {{ShapeName = "ls-6-100"}},
})